/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPageExtension2;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerDefaultPage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerDescriptor;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerSelectionPage;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BuildpathContainerWizard
extends Wizard {
    private BuildpathContainerDescriptor fPageDesc;
    private IBuildpathEntry fEntryToEdit;
    private IBuildpathEntry[] fNewEntries;
    private IBuildpathContainerPage fContainerPage;
    private IScriptProject fCurrProject;
    private IBuildpathEntry[] fCurrBuildpath;
    private BuildpathContainerSelectionPage fSelectionWizardPage;

    public BuildpathContainerWizard(IBuildpathEntry entryToEdit, IScriptProject currProject, IBuildpathEntry[] currEntries) {
        this(entryToEdit, null, currProject, currEntries);
    }

    public BuildpathContainerWizard(BuildpathContainerDescriptor pageDesc, IScriptProject currProject, IBuildpathEntry[] currEntries) {
        this(null, pageDesc, currProject, currEntries);
    }

    private BuildpathContainerWizard(IBuildpathEntry entryToEdit, BuildpathContainerDescriptor pageDesc, IScriptProject currProject, IBuildpathEntry[] currEntries) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntries = null;
        this.fCurrProject = currProject;
        this.fCurrBuildpath = currEntries;
        String title = entryToEdit == null ? NewWizardMessages.BuildpathContainerWizard_new_title : NewWizardMessages.BuildpathContainerWizard_edit_title;
        this.setWindowTitle(title);
    }

    public IBuildpathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof IBuildpathContainerPageExtension2) {
                this.fNewEntries = ((IBuildpathContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                IBuildpathEntry[] iBuildpathEntryArray;
                IBuildpathEntry entry = this.fContainerPage.getSelection();
                if (entry != null) {
                    IBuildpathEntry[] iBuildpathEntryArray2 = new IBuildpathEntry[1];
                    iBuildpathEntryArray = iBuildpathEntryArray2;
                    iBuildpathEntryArray2[0] = entry;
                } else {
                    iBuildpathEntryArray = null;
                }
                this.fNewEntries = iBuildpathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            BuildpathContainerDescriptor[] containers = BuildpathContainerDescriptor.getDescriptors(this.fCurrProject);
            this.fSelectionWizardPage = new BuildpathContainerSelectionPage(containers);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new BuildpathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            BuildpathContainerDescriptor[] containers = BuildpathContainerDescriptor.getDescriptors();
            String type = this.fEntryToEdit.getPath().segment(0);
            if (type.equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
                IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)this.fCurrProject);
                if (toolkit != null) {
                    String interpreterContainerID = toolkit.getInterpreterContainerId();
                    BuildpathContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit, interpreterContainerID);
                    this.fContainerPage = this.getContainerPage(descriptor);
                    this.addPage(this.fContainerPage);
                }
            } else {
                BuildpathContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit);
                this.fContainerPage = this.getContainerPage(descriptor);
                this.addPage(this.fContainerPage);
            }
        }
        super.addPages();
    }

    private IBuildpathContainerPage getContainerPage(BuildpathContainerDescriptor pageDesc) {
        IBuildpathContainerPage containerPage = null;
        if (pageDesc != null) {
            IBuildpathContainerPage page = pageDesc.getPage();
            if (page != null) {
                return page;
            }
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new BuildpathContainerDefaultPage();
            if (pageDesc != null) {
                pageDesc.setPage(containerPage);
            }
        }
        if (containerPage instanceof IBuildpathContainerPageExtension) {
            ((IBuildpathContainerPageExtension)((Object)containerPage)).initialize(this.fCurrProject, this.fCurrBuildpath);
        }
        containerPage.setSelection(this.fEntryToEdit);
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            BuildpathContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = NewWizardMessages.BuildpathContainerWizard_pagecreationerror_title;
        String message = NewWizardMessages.BuildpathContainerWizard_pagecreationerror_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private BuildpathContainerDescriptor findDescriptorPage(BuildpathContainerDescriptor[] containers, IBuildpathEntry entry, String id) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry, id)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    private BuildpathContainerDescriptor findDescriptorPage(BuildpathContainerDescriptor[] containers, IBuildpathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            BuildpathContainerDescriptor[] descriptors = this.fSelectionWizardPage.getContainers();
            int i = 0;
            while (i < descriptors.length) {
                descriptors[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, BuildpathContainerWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        return dialog.open();
    }
}

