/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMNodeImpl;

class NodePool {
    private String fPackageName;
    private Map nodeRegistry = new HashMap();
    private Map classNames = new HashMap();
    private static final String CLASS_STYLE_SHEET = "CSSMMStyleSheetImpl";
    private static final String CLASS_CHARSET_RULE = "CSSMMCharsetRuleImpl";
    private static final String CLASS_FONT_FACE_RULE = "CSSMMFontFaceRuleImpl";
    private static final String CLASS_IMPORT_RULE = "CSSMMImportRuleImpl";
    private static final String CLASS_MEDIA_RULE = "CSSMMMediaRuleImpl";
    private static final String CLASS_PAGE_RULE = "CSSMMPageRuleImpl";
    private static final String CLASS_STYLE_RULE = "CSSMMStyleRuleImpl";
    private static final String CLASS_PROPERTY = "CSSMMPropertyImpl";
    private static final String CLASS_DESCRIPTOR = "CSSMMDescriptorImpl";
    private static final String CLASS_CONTAINER = "CSSMMContainerImpl";
    private static final String CLASS_NUMBER = "CSSMMNumberImpl";
    private static final String CLASS_KEYWORD = "CSSMMKeywordImpl";
    private static final String CLASS_UNIT = "CSSMMUnitImpl";
    private static final String CLASS_FUNCTION = "CSSMMFunctionImpl";
    private static final String CLASS_STRING = "CSSMMStringImpl";
    private static final String CLASS_CATEGORY = "CSSMMCategoryImpl";
    private static final String CLASS_SELECTOR_EXPRESSION = "CSSMMSelectorExpressionImpl";
    private static final String CLASS_PSEUDO_CLASS = "CSSMMPseudoClassImpl";
    private static final String CLASS_PSEUDO_ELEMENT = "CSSMMPseudoElementImpl";

    NodePool() {
        this.initializeClassNameTable();
    }

    CSSMMNodeImpl getNode(String tagName, String nodeName) {
        CSSMMNodeImpl node;
        String className;
        if (nodeName != null) {
            nodeName = nodeName.toLowerCase();
        }
        if ((className = (String)this.classNames.get(tagName)) == null) {
            return null;
        }
        HashMap<String, CSSMMNodeImpl> nodes = (HashMap<String, CSSMMNodeImpl>)this.nodeRegistry.get(className);
        if (nodes == null) {
            nodes = new HashMap<String, CSSMMNodeImpl>();
            this.nodeRegistry.put(className, nodes);
        }
        if ((node = (CSSMMNodeImpl)nodes.get(nodeName)) == null) {
            node = this.createNewNode(className);
            nodes.put(nodeName, node);
        }
        return node;
    }

    private CSSMMNodeImpl createNewNode(String className) {
        CSSMMNodeImpl node = null;
        if (className != null) {
            className = this.getPackageName() + "." + (String)className;
            try {
                node = (CSSMMNodeImpl)Class.forName((String)className).newInstance();
            }
            catch (IllegalAccessException e) {
                Logger.logException(e);
            }
            catch (InstantiationException e) {
                Logger.logException(e);
            }
            catch (ClassNotFoundException e) {
                Logger.logException(e);
            }
        }
        return node;
    }

    Iterator getStrayNodes() {
        ArrayList<CSSMMNodeImpl> strayNodes = new ArrayList<CSSMMNodeImpl>();
        for (Map nodes : this.nodeRegistry.values()) {
            for (CSSMMNodeImpl node : nodes.values()) {
                if (node.getReferenceCount() != 0) continue;
                strayNodes.add(node);
            }
        }
        return strayNodes.iterator();
    }

    private String getPackageName() {
        if (this.fPackageName == null) {
            String className = this.getClass().getName();
            int pos = className.lastIndexOf(46);
            this.fPackageName = pos > 0 ? className.substring(0, pos) : "";
        }
        return this.fPackageName;
    }

    void initializeClassNameTable() {
        this.classNames.put("stylesheet-def", CLASS_STYLE_SHEET);
        this.classNames.put("charset-rule-def", CLASS_CHARSET_RULE);
        this.classNames.put("charset-rule", CLASS_CHARSET_RULE);
        this.classNames.put("fontface-rule-def", CLASS_FONT_FACE_RULE);
        this.classNames.put("fontface-rule", CLASS_FONT_FACE_RULE);
        this.classNames.put("import-rule-def", CLASS_IMPORT_RULE);
        this.classNames.put("import-rule", CLASS_IMPORT_RULE);
        this.classNames.put("media-rule-def", CLASS_MEDIA_RULE);
        this.classNames.put("media-rule", CLASS_MEDIA_RULE);
        this.classNames.put("page-rule-def", CLASS_PAGE_RULE);
        this.classNames.put("page-rule", CLASS_PAGE_RULE);
        this.classNames.put("style-rule-def", CLASS_STYLE_RULE);
        this.classNames.put("style-rule", CLASS_STYLE_RULE);
        this.classNames.put("property-def", CLASS_PROPERTY);
        this.classNames.put("property", CLASS_PROPERTY);
        this.classNames.put("descriptor-def", CLASS_DESCRIPTOR);
        this.classNames.put("descriptor", CLASS_DESCRIPTOR);
        this.classNames.put("container-def", CLASS_CONTAINER);
        this.classNames.put("container", CLASS_CONTAINER);
        this.classNames.put("number-def", CLASS_NUMBER);
        this.classNames.put("number", CLASS_NUMBER);
        this.classNames.put("keyword-def", CLASS_KEYWORD);
        this.classNames.put("keyword", CLASS_KEYWORD);
        this.classNames.put("unit", CLASS_UNIT);
        this.classNames.put("unit-def", CLASS_UNIT);
        this.classNames.put("function", CLASS_FUNCTION);
        this.classNames.put("function-def", CLASS_FUNCTION);
        this.classNames.put("selector-expression", CLASS_SELECTOR_EXPRESSION);
        this.classNames.put("pseudo-element", CLASS_PSEUDO_ELEMENT);
        this.classNames.put("pseudo-element-def", CLASS_PSEUDO_ELEMENT);
        this.classNames.put("pseudo-class", CLASS_PSEUDO_CLASS);
        this.classNames.put("pseudo-class-def", CLASS_PSEUDO_CLASS);
        this.classNames.put("string", CLASS_STRING);
        this.classNames.put("category-def", CLASS_CATEGORY);
    }
}

