/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.internal.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.internal.databinding.DatabindingValidationUtil;

public class EmfValidationTargetToModelUpdateValueStrategy
extends EMFUpdateValueStrategy {
    private EObject owner;
    private EStructuralFeature feature;
    private DatabindingValidationUtil databindingValidationUtil;
    private boolean firstValidateBeforeSet = true;

    public EmfValidationTargetToModelUpdateValueStrategy(EObject owner, EStructuralFeature feature, DatabindingValidationUtil databindingValidationUtil) {
        this.owner = owner;
        this.feature = feature;
        this.databindingValidationUtil = databindingValidationUtil;
    }

    protected IStatus doSet(IObservableValue observableValue, Object value) {
        super.doSet(observableValue, !"".equals(value) ? value : null);
        return this.validationStatus();
    }

    public IStatus validateBeforeSet(Object value) {
        if (this.firstValidateBeforeSet) {
            this.firstValidateBeforeSet = false;
            return this.validationStatus();
        }
        return super.validateBeforeSet(value);
    }

    public Object convert(Object value) {
        if (this.converter != null) {
            try {
                return this.converter.convert(value);
            }
            catch (RuntimeException e) {
                return e;
            }
        }
        return value;
    }

    public IStatus validateAfterConvert(Object value) {
        if (value instanceof RuntimeException) {
            return ValidationStatus.error((String)value.toString());
        }
        return super.validateAfterConvert(value);
    }

    private IStatus validationStatus() {
        Iterable<Diagnostic> filtered = this.databindingValidationUtil.getDiagnostic(this.owner, this.feature);
        for (Diagnostic d : filtered) {
            int severity = d.getSeverity();
            if (severity != 4) continue;
            return ValidationStatus.error((String)d.getMessage());
        }
        return ValidationStatus.ok();
    }
}

