/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.dsl.model.EmfFeatureAccess;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslGuiceModuleHelper;
import org.eclipse.emf.parsley.dsl.validation.AbstractEmfParsleyDslValidator;
import org.eclipse.emf.parsley.dsl.validation.EmfParsleyDslExpectedSuperTypes;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.Multimaps2;
import org.eclipse.xtext.xbase.validation.JvmGenericTypeValidator;

@ComposedChecks(validators={JvmGenericTypeValidator.class})
public class EmfParsleyDslValidator
extends AbstractEmfParsleyDslValidator {
    public static final String TYPE_MISMATCH = "org.eclipse.emf.parsley.dsl.TypeMismatch";
    public static final String FINAL_FIELD_NOT_INITIALIZED = "org.eclipse.emf.parsley.dsl.FinalFieldNotInitialized";
    public static final String TOO_LITTLE_TYPE_INFORMATION = "org.eclipse.emf.parsley.dsl.TooLittleTypeInformation";
    public static final String DUPLICATE_ELEMENT = "org.eclipse.emf.parsley.dsl.DuplicateElement";
    @Inject
    @Extension
    private EmfParsleyDslExpectedSuperTypes expectedSuperTypes;
    @Inject
    @Extension
    private EmfParsleyDslGuiceModuleHelper guiceModuleHelper;
    @Inject
    private ResourceDescriptionsProvider rdp;
    @Inject
    private IContainer.Manager cm;
    private static final ModelPackage MODEL_PACKAGE = ModelPackage.eINSTANCE;

    @Check(value=CheckType.NORMAL)
    public void checkDuplicateViewSpecificationAcrossFiles(ViewSpecification viewSpecification) {
        Iterable<IEObjectDescription> descriptions = this.getVisibleEObjectDescriptions(viewSpecification, ModelPackage.Literals.VIEW_SPECIFICATION);
        for (IEObjectDescription desc : descriptions) {
            if (!Objects.equals(desc.getQualifiedName().toString(), viewSpecification.getId()) || Objects.equals(desc.getEObjectOrProxy(), viewSpecification) || Objects.equals(desc.getEObjectURI().trimFragment(), viewSpecification.eResource().getURI())) continue;
            this.error(String.format("The part id %s is already defined", viewSpecification.getId()), (EStructuralFeature)MODEL_PACKAGE.getViewSpecification_Id(), DUPLICATE_ELEMENT, new String[0]);
            return;
        }
    }

    private Iterable<IEObjectDescription> getVisibleEObjectDescriptions(EObject o, EClass type) {
        return Iterables.concat((Iterable)ListExtensions.map(this.getVisibleContainers(o), container -> container.getExportedObjectsByType(type)));
    }

    private List<IContainer> getVisibleContainers(EObject o) {
        IResourceDescriptions index = this.rdp.getResourceDescriptions(o.eResource());
        IResourceDescription rd = index.getResourceDescription(o.eResource().getURI());
        return this.cm.getVisibleContainers(rd, index);
    }

    @Check
    public void checkViewSpecification(ViewSpecification viewSpecification) {
        this.checkType(viewSpecification, viewSpecification.getType(), this.expectedSuperTypes.getExpectedSupertype(viewSpecification), (EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__TYPE);
    }

    @Check
    public void checkEmfFeatureAccess(EmfFeatureAccess emfFeatureAccess) {
        this.checkType(emfFeatureAccess, emfFeatureAccess.getParameterType(), this.expectedSuperTypes.getExpectedSupertype(emfFeatureAccess), (EStructuralFeature)ModelPackage.Literals.EMF_FEATURE_ACCESS__PARAMETER_TYPE);
    }

    @Check
    public void checkExtendsClause(WithExtendsClause withExtendsClause) {
        if (withExtendsClause.getExtendsClause() != null) {
            this.checkType(withExtendsClause.getExtendsClause(), withExtendsClause.getExtendsClause().getSuperType(), this.expectedSuperTypes.getExpectedSupertype(withExtendsClause), (EStructuralFeature)ModelPackage.Literals.EXTENDS_CLAUSE__SUPER_TYPE);
        }
    }

    @Check
    public void checkFieldInitialization(FieldSpecification f) {
        if (!f.isWriteable() && f.getRight() == null) {
            this.error(String.format("The blank final field %s may not have been initialized", f.getName()), (EStructuralFeature)ModelPackage.Literals.FIELD_SPECIFICATION__NAME, FINAL_FIELD_NOT_INITIALIZED, new String[0]);
        }
        if (f.getType() == null && f.getRight() == null) {
            this.error(String.format("The field %s needs an explicit type since there is no initialization expression to infer the type from.", f.getName()), f, (EStructuralFeature)ModelPackage.Literals.FIELD_SPECIFICATION__NAME, TOO_LITTLE_TYPE_INFORMATION, new String[0]);
        }
    }

    @Check
    public void checkModule(Module module) {
        JvmGenericType guiceModuleClass = this.guiceModuleHelper.getModuleInferredType(module);
        if (guiceModuleClass == null) {
            return;
        }
        PartsSpecifications partsSpecifications = module.getPartsSpecifications();
        if (partsSpecifications != null) {
            this.checkDuplicateViewSpecifications((List<PartSpecification>)partsSpecifications.getParts());
        }
    }

    private void checkDuplicateViewSpecifications(List<PartSpecification> parts) {
        ListMultimap map = Multimaps2.newLinkedHashListMultimap();
        Iterable filtered = Iterables.filter(parts, ViewSpecification.class);
        for (ViewSpecification p : filtered) {
            map.put((Object)p.getId(), (Object)p);
        }
        this.checkDuplicates(map, d -> this.error("Duplicate element", (EObject)d, (EStructuralFeature)MODEL_PACKAGE.getViewSpecification_Id(), DUPLICATE_ELEMENT, new String[0]));
    }

    private <T> void checkDuplicates(ListMultimap<String, T> map, Procedures.Procedure1<? super T> errorReporter) {
        Set entrySet = map.asMap().entrySet();
        for (Map.Entry entry : entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            if (duplicates.size() <= 1) continue;
            for (Object d : duplicates) {
                errorReporter.apply(d);
            }
        }
    }

    protected void checkType(EObject context, JvmTypeReference actualType, Class<?> expectedType, EStructuralFeature feature) {
        if (actualType != null) {
            boolean allSuperTypesAreObject;
            JvmType jvmType = actualType.getType();
            if (jvmType instanceof JvmGenericType && (allSuperTypesAreObject = ((JvmGenericType)jvmType).getSuperTypes().stream().allMatch(t -> Objects.equals(t.getIdentifier(), "java.lang.Object")))) {
                return;
            }
            LightweightTypeReference lightweightActualType = this.toLightweightTypeReference(actualType);
            if (!lightweightActualType.isSubtypeOf(expectedType)) {
                this.error(String.format("Type mismatch: cannot convert from %s to %s", actualType.getSimpleName(), expectedType.getSimpleName()), context, feature, TYPE_MISMATCH, new String[0]);
            }
        }
    }
}

