/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.mapping.IBranchDeletionSupport;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTable;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.db.Batch;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CommitInfoTable
extends DBStoreTable
implements IBranchDeletionSupport {
    private boolean withMergeSource;
    private IDBField timeStamp;
    private IDBField previousTimeStamp;
    private IDBField branch;
    private IDBField user;
    private IDBField comment;
    private IDBField mergedBranch;
    private IDBField mergedTimeStamp;
    private String sqlInsert;

    public CommitInfoTable(IDBStore store) {
        super(store, NAMES.COMMIT_INFOS);
    }

    public void writeCommitInfo(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setLong(1, timeStamp);
                stmt.setLong(2, previousTimeStamp);
                stmt.setInt(3, branch.getID());
                stmt.setString(4, userID);
                stmt.setString(5, comment);
                if (this.withMergeSource) {
                    if (mergeSource != null) {
                        stmt.setInt(6, mergeSource.getBranch().getID());
                        stmt.setLong(7, mergeSource.getTimeStamp());
                    } else {
                        stmt.setNull(6, DBType.INTEGER.getCode());
                        stmt.setNull(7, DBType.BIGINT.getCode());
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadCommitInfos(IDBStoreAccessor accessor, CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        int count = CDOCommitInfoUtil.decodeCount((long)endTime);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.timeStamp);
        builder.append(", ");
        builder.append(this.previousTimeStamp);
        builder.append(", ");
        builder.append(this.user);
        builder.append(", ");
        builder.append(this.comment);
        if (branch == null) {
            builder.append(", ");
            builder.append(this.branch);
        }
        if (this.withMergeSource) {
            builder.append(", ");
            builder.append(this.mergedBranch);
            builder.append(", ");
            builder.append(this.mergedTimeStamp);
        }
        builder.append(" FROM ");
        builder.append(this.table());
        boolean where = false;
        if (branch != null) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(this.branch);
            builder.append("=");
            builder.append(branch.getID());
            where = true;
        }
        if (startTime != 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(this.timeStamp);
            builder.append(count < 0 ? "<=" : ">=");
            builder.append(startTime);
            where = true;
        }
        if (endTime > 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(this.timeStamp);
            builder.append("<=");
            builder.append(endTime);
            where = true;
        }
        builder.append(" ORDER BY ");
        builder.append(this.timeStamp);
        builder.append(count < 0 || 0L <= endTime && endTime <= startTime ? " DESC" : " ASC");
        String sql = builder.toString();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        InternalRepository repository = (InternalRepository)this.store().getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        count = Math.abs(count);
        try {
            try {
                resultSet = stmt.executeQuery();
                while (count-- > 0) {
                    if (!resultSet.next()) {
                        return;
                    }
                    int column = 0;
                    long timeStamp = resultSet.getLong(++column);
                    long previousTimeStamp = resultSet.getLong(++column);
                    String userID = resultSet.getString(++column);
                    String comment = resultSet.getString(++column);
                    CDOBranch infoBranch = branch;
                    if (infoBranch == null) {
                        int id = resultSet.getInt(++column);
                        infoBranch = branchManager.getBranch(id);
                    }
                    CDOBranchPoint mergeSource = null;
                    if (this.withMergeSource) {
                        int id = resultSet.getInt(++column);
                        if (!resultSet.wasNull()) {
                            InternalCDOBranch mergedBranch = branchManager.getBranch(id);
                            long mergedTimeStamp = resultSet.getLong(++column);
                            mergeSource = mergedBranch.getPoint(mergedTimeStamp);
                        }
                    }
                    CDOCommitInfo commitInfo = commitInfoManager.createCommitInfo(infoBranch, timeStamp, previousTimeStamp, userID, comment, mergeSource, null);
                    handler.handleCommitInfo(commitInfo);
                }
                return;
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void deleteBranches(IDBStoreAccessor accessor, Batch batch, String idList) {
        batch.add("DELETE FROM " + this.table() + " WHERE " + this.branch + " IN (" + idList + ")");
        batch.add("UPDATE " + this.table() + " upd SET " + this.previousTimeStamp + "=(" + "SELECT MAX(" + this.timeStamp + ") FROM " + this.table() + " WHERE " + this.timeStamp + "<upd." + this.timeStamp + ") WHERE " + this.timeStamp + " IN (" + "SELECT " + this.timeStamp + " FROM " + this.table() + " WHERE " + this.previousTimeStamp + " NOT IN (SELECT " + this.timeStamp + " FROM " + this.table() + ")" + ")");
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        out.writeBoolean(this.withMergeSource);
        String where = " WHERE " + this.timeStamp + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table(), null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        boolean actualWithMergeSource = in.readBoolean();
        if (actualWithMergeSource != this.withMergeSource) {
            throw new IllegalStateException("Commit info data mismatch. Expected: " + (this.withMergeSource ? "with" : "without") + " merge source. Actual: " + (actualWithMergeSource ? "with" : "without") + " merge source.");
        }
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table(), (OMMonitor)monitor.fork());
    }

    public void repairAfterCrash(Connection connection) {
        long lastCommitTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)this.timeStamp, (String[])new String[0]);
        long lastNonLocalCommitTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)this.timeStamp, (String[])new String[]{"0<=" + this.branch});
        if (lastNonLocalCommitTime == 0L) {
            lastNonLocalCommitTime = lastCommitTime;
        }
        DBStore store = (DBStore)this.store();
        store.setLastCommitTime(lastCommitTime);
        store.setLastNonLocalCommitTime(lastNonLocalCommitTime);
    }

    @Override
    protected void firstActivate(IDBTable table) {
        this.timeStamp = table.addField(NAMES.TIMESTAMP, DBType.BIGINT, true);
        this.previousTimeStamp = table.addField(NAMES.PREVIOUS_TIMESTAMP, DBType.BIGINT);
        this.branch = table.addField(NAMES.BRANCH, DBType.INTEGER);
        this.user = table.addField(NAMES.USER, DBType.VARCHAR);
        this.comment = table.addField(NAMES.COMMENT, DBType.VARCHAR);
        table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.timeStamp});
        table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.branch});
        if (this.withMergeSource) {
            this.addMergeSourceFields(table);
        }
    }

    @Override
    protected void reActivate(IDBTable table) {
        this.timeStamp = table.getField(NAMES.TIMESTAMP);
        this.previousTimeStamp = table.getField(NAMES.PREVIOUS_TIMESTAMP);
        this.branch = table.getField(NAMES.BRANCH);
        this.user = table.getField(NAMES.USER);
        this.comment = table.getField(NAMES.COMMENT);
        this.mergedBranch = table.getField(NAMES.MERGED_BRANCH);
        this.mergedTimeStamp = table.getField(NAMES.MERGED_TIMESTAMP);
        if (this.withMergeSource && this.mergedBranch == null) {
            this.store().getDatabase().updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    IDBTable table = schema.getTable(NAMES.COMMIT_INFOS);
                    CommitInfoTable.this.addMergeSourceFields(table);
                }
            });
        }
    }

    @Override
    protected void doActivate() throws Exception {
        this.withMergeSource = this.store().getRepository().getCommitInfoStorage() == CDOCommonRepository.CommitInfoStorage.WITH_MERGE_SOURCE;
        super.doActivate();
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.table());
        builder.append("(");
        builder.append(this.timeStamp);
        builder.append(", ");
        builder.append(this.previousTimeStamp);
        builder.append(", ");
        builder.append(this.branch);
        builder.append(", ");
        builder.append(this.user);
        builder.append(", ");
        builder.append(this.comment);
        if (this.withMergeSource) {
            builder.append(", ");
            builder.append(this.mergedBranch);
            builder.append(", ");
            builder.append(this.mergedTimeStamp);
        }
        builder.append(") VALUES (?, ?, ?, ?, ?");
        if (this.withMergeSource) {
            builder.append(", ?, ?");
        }
        builder.append(")");
        this.sqlInsert = builder.toString();
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.sqlInsert = null;
        super.doDeactivate();
    }

    private void addMergeSourceFields(IDBTable table) {
        this.mergedBranch = table.addField(NAMES.MERGED_BRANCH, DBType.INTEGER);
        this.mergedTimeStamp = table.addField(NAMES.MERGED_TIMESTAMP, DBType.BIGINT);
        table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.mergedBranch, this.mergedTimeStamp});
    }

    private static final class NAMES {
        private static final String COMMIT_INFOS = NAMES.name("cdo_commit_infos");
        private static final String TIMESTAMP = NAMES.name("commit_time");
        private static final String PREVIOUS_TIMESTAMP = NAMES.name("previous_time");
        private static final String BRANCH = NAMES.name("branch_id");
        private static final String USER = NAMES.name("user_id");
        private static final String COMMENT = NAMES.name("commit_comment");
        private static final String MERGED_BRANCH = NAMES.name("merged_branch");
        private static final String MERGED_TIMESTAMP = NAMES.name("merged_time");

        private NAMES() {
        }

        private static String name(String name) {
            return DBUtil.name((String)name, CommitInfoTable.class);
        }
    }
}

