/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

final class DiscoverNatureSupportJob
extends Job {
    private final String natureId;
    private List<? extends INode> nodes;

    DiscoverNatureSupportJob(String natureId) {
        super(NLS.bind((String)Messages.MissingNatureDetector_jobName, (Object)natureId));
        this.natureId = natureId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference locatorReference = bundleContext.getServiceReference(IMarketplaceServiceLocator.class);
        IMarketplaceServiceLocator locator = (IMarketplaceServiceLocator)bundleContext.getService(locatorReference);
        IMarketplaceService marketplaceService = locator.getDefaultMarketplaceService();
        String fileExtensionTag = "nature_" + this.natureId;
        try {
            ISearchResult searchResult = marketplaceService.tagged(fileExtensionTag, monitor);
            this.nodes = searchResult.getNodes();
        }
        catch (CoreException ex) {
            Status status = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.LookupByNatureJob_discoveryFailed, (Object)this.natureId), (Throwable)ex);
            MarketplaceClientUi.getLog().log((IStatus)status);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public Collection<INode> getCandidates() {
        return this.nodes;
    }

    public String getNatureId() {
        return this.natureId;
    }
}

