/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class RemoveVarOrInferredLambdaParameterTypesFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public RemoveVarOrInferredLambdaParameterTypesFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static RemoveVarOrInferredLambdaParameterTypesFixCore createRemoveVarOrInferredLambdaParameterTypesFix(CompilationUnit compilationUnit, ASTNode node) {
        LambdaExpression lambda;
        IJavaElement root = compilationUnit.getJavaElement();
        ASTNode parent = node.getParent();
        if (parent == null || root == null) {
            return null;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        boolean checkForVarTypes = false;
        if (JavaModelUtil.is11OrHigher(javaProject)) {
            checkForVarTypes = true;
        }
        if (node instanceof LambdaExpression) {
            lambda = (LambdaExpression)node;
        } else if (node.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY && parent.getLocationInParent() == LambdaExpression.PARAMETERS_PROPERTY) {
            lambda = (LambdaExpression)node.getParent().getParent();
        } else {
            return null;
        }
        List lambdaParameters = lambda.parameters();
        int noOfLambdaParams = lambdaParameters.size();
        if (noOfLambdaParams == 0) {
            return null;
        }
        if (!(lambdaParameters.get(0) instanceof SingleVariableDeclaration)) {
            return null;
        }
        IMethodBinding methodBinding = lambda.resolveMethodBinding();
        if (methodBinding == null) {
            return null;
        }
        String label = CorrectionMessages.QuickAssistProcessor_remove_lambda_parameter_types;
        return new RemoveVarOrInferredLambdaParameterTypesFixCore(label, compilationUnit, new RemoveVarOrInferredLambdaParameterTypesProposalOperation(lambda, noOfLambdaParams, lambdaParameters, checkForVarTypes));
    }

    private static class RemoveVarOrInferredLambdaParameterTypesProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private LambdaExpression lambda;
        private int noOfLambdaParams;
        private List<VariableDeclaration> lambdaParameters;
        private boolean checkForVarTypes;

        public RemoveVarOrInferredLambdaParameterTypesProposalOperation(LambdaExpression lambda, int noOfLambdaParams, List<VariableDeclaration> lambdaParameters, boolean checkForVarTypes) {
            this.lambda = lambda;
            this.noOfLambdaParams = noOfLambdaParams;
            this.lambdaParameters = lambdaParameters;
            this.checkForVarTypes = checkForVarTypes;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover remover = cuRewrite.getImportRemover();
            rewrite.set((ASTNode)this.lambda, (StructuralPropertyDescriptor)LambdaExpression.PARENTHESES_PROPERTY, (Object)Boolean.TRUE, null);
            int i = 0;
            while (i < this.noOfLambdaParams) {
                VariableDeclaration param = this.lambdaParameters.get(i);
                Type oldType = null;
                if (param instanceof SingleVariableDeclaration) {
                    SingleVariableDeclaration curParent = (SingleVariableDeclaration)param;
                    oldType = curParent.getType();
                    if (oldType != null && (!this.checkForVarTypes || this.checkForVarTypes && !oldType.isVar())) {
                        remover.registerRemovedNode((ASTNode)oldType);
                    }
                    VariableDeclarationFragment newParam = ast.newVariableDeclarationFragment();
                    newParam.setName(ast.newSimpleName(param.getName().getIdentifier()));
                    rewrite.replace((ASTNode)param, (ASTNode)newParam, null);
                }
                ++i;
            }
        }
    }
}

