/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ILink;
import org.eclipse.help.IToc;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.xml.sax.SAXException;

public class TocValidator {
    private static final boolean DEBUG = false;
    private final HashMap<String, Object> processedTocs = new HashMap();
    private final TocFileParser parser = new TocFileParser();

    public static List<BrokenLink> validate(String[] hrefs) throws IOException, SAXException, ParserConfigurationException {
        return TocValidator.filteredValidate(hrefs, new PassThroughFilter());
    }

    public static List<BrokenLink> filteredValidate(String[] hrefs, Filter filter) throws IOException, SAXException, ParserConfigurationException {
        TocValidator v = new TocValidator();
        ArrayList<BrokenLink> result = new ArrayList<BrokenLink>();
        String[] stringArray = hrefs;
        int n = hrefs.length;
        int n2 = 0;
        while (n2 < n) {
            String href = stringArray[n2];
            v.processToc(href, null, result, filter);
            ++n2;
        }
        return result;
    }

    private TocValidator() {
    }

    private void processToc(String href, String plugin, ArrayList<BrokenLink> result, Filter filter) throws IOException, SAXException, ParserConfigurationException {
        String path;
        if (href.startsWith("/")) {
            int index = (href = href.substring(1)).indexOf(47);
            if (index == -1) {
                throw new IOException("Invalid parameters supplied to the validate method.");
            }
            plugin = href.substring(0, index);
            path = href.substring(index + 1);
        } else {
            path = href;
        }
        if (plugin == null) {
            throw new IOException("Invalid parameters supplied to the validate method.");
        }
        String key = "/" + plugin + "/" + path;
        if (this.processedTocs.get(key) != null) {
            return;
        }
        this.processedTocs.put(key, new Object());
        TocContribution contribution = this.parser.parse(new TocFile(plugin, path, true, "en", null, null));
        this.process((IUAElement)contribution.getToc(), plugin, path, result, filter);
    }

    private void process(IUAElement element, String plugin, String path, ArrayList<BrokenLink> result, Filter filter) throws SAXException, ParserConfigurationException {
        IUAElement[] children;
        if (element instanceof ILink) {
            ILink link = (ILink)element;
            href = link.getToc();
            try {
                this.processToc(href, plugin, result, filter);
            }
            catch (IOException e) {
                result.add(new BrokenLink("/" + plugin + "/" + path, href));
            }
        } else if (element instanceof IHelpResource) {
            IHelpResource helpResource = (IHelpResource)element;
            if (element instanceof IToc) {
                IToc toc = (IToc)element;
                href = toc.getTopic(null).getHref();
            } else {
                href = helpResource.getHref();
            }
            if (href != null && filter.isIncluded(href) && !this.checkLink(href, plugin)) {
                result.add(new BrokenLink("/" + plugin + "/" + path, href));
            }
        }
        IUAElement[] iUAElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IUAElement child = iUAElementArray[n2];
            this.process(child, plugin, path, result, filter);
            ++n2;
        }
    }

    private boolean checkLink(String href, String plugin) {
        if (href.startsWith("http")) {
            return true;
        }
        boolean result = true;
        InputStream i = null;
        try {
            HelpURLConnection c = new HelpURLConnection(this.createURL(href, plugin));
            i = c.getInputStream();
            if (i == null) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        if (i != null) {
            try {
                i.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            i = null;
        }
        return result;
    }

    private URL createURL(String href, String plugin) throws MalformedURLException {
        StringBuilder url = new StringBuilder("file:/");
        url.append(plugin);
        url.append("/");
        url.append(href);
        return new URL(url.toString());
    }

    public static class BrokenLink {
        private final String tocID;
        private final String href;

        private BrokenLink(String tocID, String href) {
            this.tocID = tocID;
            this.href = href;
        }

        public String getTocID() {
            return this.tocID;
        }

        public String getHref() {
            return this.href;
        }
    }

    public static abstract class Filter {
        public abstract boolean isIncluded(String var1);
    }

    public static class PassThroughFilter
    extends Filter {
        @Override
        public boolean isIncluded(String href) {
            return true;
        }
    }
}

