/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.parsers;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codelibs.nekohtml.parsers.SAXToDOMHandler;
import org.codelibs.nekohtml.sax.HTMLSAXParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMParser {
    protected final HTMLSAXParser saxParser = new HTMLSAXParser();
    protected final DocumentBuilder documentBuilder;
    protected Document document;

    public DOMParser() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        this.documentBuilder = factory.newDocumentBuilder();
    }

    public void parse(InputSource source) throws SAXException, IOException {
        SAXToDOMHandler handler = new SAXToDOMHandler(this.documentBuilder);
        this.saxParser.setContentHandler(handler);
        this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        this.saxParser.parse(source);
        this.document = handler.getDocument();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxParser.setErrorHandler(errorHandler);
        this.documentBuilder.setErrorHandler(errorHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxParser.setEntityResolver(entityResolver);
        this.documentBuilder.setEntityResolver(entityResolver);
    }

    public void setFeature(String name, boolean value) throws SAXException {
        try {
            this.saxParser.setFeature(name, value);
        }
        catch (Exception e) {
            throw new SAXException("Feature not supported: " + name, e);
        }
    }

    public boolean getFeature(String name) throws SAXException {
        try {
            return this.saxParser.getFeature(name);
        }
        catch (Exception e) {
            throw new SAXException("Feature not supported: " + name, e);
        }
    }

    public void setProperty(String name, Object value) throws SAXException {
        try {
            this.saxParser.setProperty(name, value);
        }
        catch (Exception e) {
            throw new SAXException("Property not supported: " + name, e);
        }
    }

    public Object getProperty(String name) throws SAXException {
        try {
            return this.saxParser.getProperty(name);
        }
        catch (Exception e) {
            throw new SAXException("Property not supported: " + name, e);
        }
    }
}

