/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.axisconverter;

import java.security.InvalidParameterException;
import org.eclipse.swtchart.extensions.axisconverter.Messages;
import org.eclipse.swtchart.extensions.core.AbstractAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;

public class MillisecondsToScanNumberConverter
extends AbstractAxisScaleConverter
implements IAxisScaleConverter {
    private int scanDelay;
    private int scanInterval;

    public MillisecondsToScanNumberConverter(int scanDelay, int scanInterval) throws InvalidParameterException {
        if (scanDelay < 0) {
            throw new InvalidParameterException(Messages.getString("SCAN_MUST_BE_GE_0"));
        }
        if (scanInterval <= 0) {
            throw new InvalidParameterException(Messages.getString("SCAN_MUST_BE_G_0"));
        }
        this.scanDelay = scanDelay;
        this.scanInterval = scanInterval;
    }

    @Override
    public double convertToSecondaryUnit(double primaryValue) {
        if (primaryValue < (double)this.scanDelay) {
            return 0.0;
        }
        return (int)((primaryValue - (double)this.scanDelay) / (double)this.scanInterval) + 1;
    }

    @Override
    public double convertToPrimaryUnit(double secondaryValue) {
        if (secondaryValue < 1.0) {
            return 0.0;
        }
        return this.scanDelay + (int)(secondaryValue - 1.0) * this.scanInterval;
    }
}

