/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractCodanCMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class QuickFixUseDotOperator
extends AbstractCodanCMarkerResolution {
    public String getLabel() {
        return QuickFixMessages.QuickFixUseDotOperator_replace_ptr;
    }

    public void apply(IMarker marker, IDocument document) {
        int lineNum = marker.getAttribute("lineNumber", -1);
        try {
            if (lineNum >= 0) {
                FindReplaceDocumentAdapter dad = new FindReplaceDocumentAdapter(document);
                int lineOffset = document.getLineOffset(lineNum - 1);
                int columnOffset = this.getColumnOffset(marker);
                try {
                    IRegion region = dad.find(lineOffset + columnOffset, "->", true, true, true, false);
                    if (region == null) {
                        CheckersUiActivator.log("QuickFixUseDotOperator failed to find '->'");
                        return;
                    }
                    document.replace(region.getOffset(), 2, ".");
                }
                catch (BadLocationException e) {
                    CheckersUiActivator.log(e);
                    return;
                }
            }
            marker.delete();
        }
        catch (CoreException | BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }

    private int getColumnOffset(IMarker marker) {
        String offset = marker.getAttribute("problem.variable", "1:");
        if (offset.charAt(offset.length() - 1) == ':') {
            String strToParse = offset.substring(0, offset.length() - 1);
            return Integer.parseInt(strToParse) - 1;
        }
        return 0;
    }
}

