/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.common;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.common.HelperVisitor;
import org.eclipse.jdt.internal.common.HelperVisitorProvider;
import org.eclipse.jdt.internal.common.VisitorEnum;

public class ASTProcessor<E extends HelperVisitorProvider<V, T, E>, V, T> {
    private final LinkedHashMap<VisitorEnum, NodeHolder> nodetypelist;
    E dataholder;
    Set<ASTNode> nodesprocessed;
    LinkedList<VisitorEnum> nodetypekeylist;

    public ASTProcessor(E dataholder, Set<ASTNode> nodesprocessed) {
        this.dataholder = dataholder;
        this.nodesprocessed = nodesprocessed;
        this.nodetypelist = new LinkedHashMap();
    }

    public ASTProcessor<E, V, T> callAnnotationTypeDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callAnnotationTypeDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callAnnotationTypeDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.AnnotationTypeDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callAnnotationTypeMemberDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callAnnotationTypeMemberDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callAnnotationTypeMemberDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.AnnotationTypeMemberDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callAnonymousClassDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callAnonymousClassDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callAnonymousClassDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.AnonymousClassDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callArrayAccessVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callArrayAccessVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callArrayAccessVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ArrayAccess, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callArrayCreationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callArrayCreationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callArrayCreationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ArrayCreation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callArrayInitializerVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callArrayInitializerVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callArrayInitializerVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ArrayInitializer, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callArrayTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callArrayTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callArrayTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ArrayType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callAssertStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callAssertStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callAssertStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.AssertStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callAssignmentVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callAssignmentVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callAssignmentVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.Assignment, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callBlockVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callBlockVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callBlockVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.Block, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callBlockCommentVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callBlockCommentVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callBlockCommentVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.BlockComment, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callBooleanLiteralVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callBooleanLiteralVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callBooleanLiteralVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.BooleanLiteral, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callBreakStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callBreakStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callBreakStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.BreakStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callCastExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callCastExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callCastExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.CastExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callCatchClauseVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callCatchClauseVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callCatchClauseVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.CatchClause, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callCharacterLiteralVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callCharacterLiteralVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callCharacterLiteralVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.CharacterLiteral, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callClassInstanceCreationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callClassInstanceCreationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callClassInstanceCreationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ClassInstanceCreation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callCompilationUnitVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callCompilationUnitVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callCompilationUnitVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.CompilationUnit, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callConditionalExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callConditionalExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callConditionalExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ConditionalExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callConstructorInvocationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callConstructorInvocationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callConstructorInvocationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ConstructorInvocation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callContinueStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callContinueStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callContinueStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ContinueStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callCreationReferenceVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callCreationReferenceVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callCreationReferenceVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.CreationReference, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callDimensionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callDimensionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callDimensionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.Dimension, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callDoStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callDoStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callDoStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.DoStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callEmptyStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callEmptyStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callEmptyStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.EmptyStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callEnhancedForStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callEnhancedForStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callEnhancedForStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.EnhancedForStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callEnumConstantDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callEnumConstantDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callEnumConstantDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.EnumConstantDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callEnumDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callEnumDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callEnumDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.EnumDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callExportsDirectiveVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callExportsDirectiveVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callExportsDirectiveVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ExportsDirective, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callExpressionMethodReferenceVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callExpressionMethodReferenceVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callExpressionMethodReferenceVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ExpressionMethodReference, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callExpressionStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callExpressionStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callExpressionStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ExpressionStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callFieldAccessVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callFieldAccessVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callFieldAccessVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.FieldAccess, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callFieldDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callFieldDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callFieldDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.FieldDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callForStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callForStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callForStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ForStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callIfStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callIfStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callIfStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.IfStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callImportDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callImportDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callImportDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ImportDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callInfixExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callInfixExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callInfixExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.InfixExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callInitializerVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callInitializerVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callInitializerVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.Initializer, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callInstanceofExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callInstanceofExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callInstanceofExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.InstanceofExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callIntersectionTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callIntersectionTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callIntersectionTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.IntersectionType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callJavadocVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callJavadocVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callJavadocVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.Javadoc, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callLabeledStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callLabeledStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callLabeledStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.LabeledStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callLambdaExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callLambdaExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callLambdaExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.LambdaExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callLineCommentVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callLineCommentVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callLineCommentVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.LineComment, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMarkerAnnotationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMarkerAnnotationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMarkerAnnotationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MarkerAnnotation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMemberRefVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMemberRefVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMemberRefVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MemberRef, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMemberValuePairVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMemberValuePairVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMemberValuePairVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MemberValuePair, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMethodRefVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMethodRefVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMethodRefVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MethodRef, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMethodRefParameterVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMethodRefParameterVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMethodRefParameterVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MethodRefParameter, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMethodDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMethodDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMethodDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MethodDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMethodInvocationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callMethodInvocationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callMethodInvocationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MethodInvocation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callMethodInvocationVisitor(String methodname, BiPredicate<ASTNode, E> bs) {
        this.nodetypelist.put(VisitorEnum.MethodInvocation, new NodeHolder(bs, null, methodname));
        return this;
    }

    public ASTProcessor<E, V, T> callMethodInvocationVisitor(String methodname, BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.MethodInvocation, new NodeHolder(bs, navigate, methodname));
        return this;
    }

    public ASTProcessor<E, V, T> callModifierVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callModifierVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callModifierVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.Modifier, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callModuleDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callModuleDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callModuleDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ModuleDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callModuleModifierVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callModuleModifierVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callModuleModifierVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ModuleModifier, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callNameQualifiedTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callNameQualifiedTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callNameQualifiedTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.NameQualifiedType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callNormalAnnotationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callNormalAnnotationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callNormalAnnotationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.NormalAnnotation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callNullLiteralVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callNullLiteralVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callNullLiteralVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.NullLiteral, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callNumberLiteralVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callNumberLiteralVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callNumberLiteralVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.NumberLiteral, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callOpensDirectiveVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callOpensDirectiveVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callOpensDirectiveVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.OpensDirective, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callPackageDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callPackageDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callPackageDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.PackageDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callParameterizedTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callParameterizedTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callParameterizedTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ParameterizedType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callParenthesizedExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callParenthesizedExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callParenthesizedExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ParenthesizedExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callPatternInstanceofExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callPatternInstanceofExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callPatternInstanceofExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.PatternInstanceofExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callPostfixExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callPostfixExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callPostfixExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.PostfixExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callPrefixExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callPrefixExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callPrefixExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.PrefixExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callProvidesDirectiveVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callProvidesDirectiveVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callProvidesDirectiveVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ProvidesDirective, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callPrimitiveTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callPrimitiveTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callPrimitiveTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.PrimitiveType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callQualifiedNameVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callQualifiedNameVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callQualifiedNameVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.QualifiedName, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callQualifiedTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callQualifiedTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callQualifiedTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.QualifiedType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callRequiresDirectiveVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callRequiresDirectiveVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callRequiresDirectiveVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.RequiresDirective, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callRecordDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callRecordDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callRecordDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.RecordDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callReturnStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callReturnStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callReturnStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ReturnStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSimpleNameVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSimpleNameVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSimpleNameVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SimpleName, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSimpleTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSimpleTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSimpleTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SimpleType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSingleMemberAnnotationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSingleMemberAnnotationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSingleMemberAnnotationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SingleMemberAnnotation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSingleVariableDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSingleVariableDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSingleVariableDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SingleVariableDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callStringLiteralVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callStringLiteralVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callStringLiteralVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.StringLiteral, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSuperConstructorInvocationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSuperConstructorInvocationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSuperConstructorInvocationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SuperConstructorInvocation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSuperFieldAccessVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSuperFieldAccessVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSuperFieldAccessVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SuperFieldAccess, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSuperMethodInvocationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSuperMethodInvocationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSuperMethodInvocationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SuperMethodInvocation, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSuperMethodReferenceVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSuperMethodReferenceVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSuperMethodReferenceVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SuperMethodReference, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSwitchCaseVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSwitchCaseVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSwitchCaseVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SwitchCase, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSwitchExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSwitchExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSwitchExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SwitchExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSwitchStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSwitchStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSwitchStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SwitchStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callSynchronizedStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callSynchronizedStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callSynchronizedStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.SynchronizedStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTagElementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTagElementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTagElementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TagElement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTextBlockVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTextBlockVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTextBlockVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TextBlock, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTextElementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTextElementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTextElementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TextElement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callThisExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callThisExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callThisExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ThisExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callThrowStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callThrowStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callThrowStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.ThrowStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTryStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTryStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTryStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TryStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTypeDeclarationVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTypeDeclarationVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTypeDeclarationVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TypeDeclaration, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTypeDeclarationStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTypeDeclarationStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTypeDeclarationStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TypeDeclarationStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTypeLiteralVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTypeLiteralVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTypeLiteralVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TypeLiteral, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTypeMethodReferenceVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTypeMethodReferenceVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTypeMethodReferenceVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TypeMethodReference, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callTypeParameterVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callTypeParameterVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callTypeParameterVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.TypeParameter, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callUnionTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callUnionTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callUnionTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.UnionType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callUsesDirectiveVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callUsesDirectiveVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callUsesDirectiveVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.UsesDirective, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callVariableDeclarationExpressionVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callVariableDeclarationExpressionVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callVariableDeclarationExpressionVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.VariableDeclarationExpression, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callVariableDeclarationStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callVariableDeclarationStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callVariableDeclarationStatementVisitor(Class<?> class1, BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.VariableDeclarationStatement, new NodeHolder(bs, navigate, class1));
        return this;
    }

    public ASTProcessor<E, V, T> callVariableDeclarationStatementVisitor(Class<?> class1, BiPredicate<ASTNode, E> bs) {
        this.nodetypelist.put(VisitorEnum.VariableDeclarationStatement, new NodeHolder(bs, null, class1));
        return this;
    }

    public ASTProcessor<E, V, T> callVariableDeclarationStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.VariableDeclarationStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callVariableDeclarationFragmentVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callVariableDeclarationFragmentVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callVariableDeclarationFragmentVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.VariableDeclarationFragment, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callWhileStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callWhileStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callWhileStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.WhileStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callWildcardTypeVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callWildcardTypeVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callWildcardTypeVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.WildcardType, new NodeHolder(bs, navigate));
        return this;
    }

    public ASTProcessor<E, V, T> callYieldStatementVisitor(BiPredicate<ASTNode, E> bs) {
        return this.callYieldStatementVisitor(bs, null);
    }

    public ASTProcessor<E, V, T> callYieldStatementVisitor(BiPredicate<ASTNode, E> bs, Function<ASTNode, ASTNode> navigate) {
        this.nodetypelist.put(VisitorEnum.YieldStatement, new NodeHolder(bs, navigate));
        return this;
    }

    public void build(ASTNode node) {
        this.nodetypekeylist = new LinkedList<VisitorEnum>(this.nodetypelist.keySet());
        this.process(node, 0);
    }

    void process(ASTNode localnode, int i) {
        if (i == this.nodetypekeylist.size()) {
            return;
        }
        VisitorEnum next = this.nodetypekeylist.get(i);
        NodeHolder nodeHolder = this.nodetypelist.get((Object)next);
        BiPredicate biPredicate = nodeHolder.callee;
        HelperVisitor hv = new HelperVisitor(this.nodesprocessed, (HelperVisitorProvider)this.dataholder);
        if (nodeHolder.object != null) {
            hv.add(nodeHolder.object, next, (node, holder) -> {
                boolean test = biPredicate.test((ASTNode)node, holder);
                if (nodeHolder.navigate != null) {
                    this.process(nodeHolder.navigate.apply((ASTNode)node), i + 1);
                } else {
                    this.process((ASTNode)node, i + 1);
                }
                return test;
            });
        } else {
            hv.add(next, (node, holder) -> {
                boolean test = biPredicate.test((ASTNode)node, holder);
                if (nodeHolder.navigate != null) {
                    this.process(nodeHolder.navigate.apply((ASTNode)node), i + 1);
                } else {
                    this.process((ASTNode)node, i + 1);
                }
                return test;
            });
        }
        hv.build(localnode);
    }

    class NodeHolder {
        public BiPredicate<ASTNode, E> callee;
        public Function<ASTNode, ASTNode> navigate;
        public Object object;

        public NodeHolder(BiPredicate<ASTNode, E> callee, Function<ASTNode, ASTNode> navigate) {
            this.callee = callee;
            this.navigate = navigate;
        }

        public NodeHolder(BiPredicate<ASTNode, E> callee, Function<ASTNode, ASTNode> navigate, Object object) {
            this.callee = callee;
            this.navigate = navigate;
            this.object = object;
        }
    }
}

