/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.access;

import java.util.List;
import java.util.Optional;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.internal.base.access.Libraries;

public final class AgreementAcceptanceDelegate {
    private final AgreementAcceptanceService root;
    private final Libraries libraries;

    public AgreementAcceptanceDelegate(AgreementAcceptanceService root, Libraries libraries) {
        this.root = root;
        this.libraries = libraries;
    }

    public void accept(AgreementToAccept agreement) throws Exception {
        AgreementAcceptanceService service = this.responsibleForAcceptance(agreement);
        service.accept(() -> agreement.acceptance().content());
    }

    private AgreementAcceptanceService responsibleForAcceptance(AgreementToAccept agreement) {
        Optional<AgreementAcceptanceService> library = this.libraryResponsibleForAcceptance(agreement);
        if (library.isPresent()) {
            return library.get();
        }
        return this.root;
    }

    private Optional<AgreementAcceptanceService> libraryResponsibleForAcceptance(AgreementToAccept agreement) {
        Optional request = this.libraries.agreementsServices(agreement);
        if (!request.isPresent()) {
            return Optional.empty();
        }
        if (!((ServiceInvocationResult)request.get()).data().isPresent()) {
            return Optional.empty();
        }
        List services = (List)((ServiceInvocationResult)request.get()).data().get();
        if (services.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((AgreementAcceptanceService)services.get(0));
    }
}

