/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappingRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmMappingRelationship;
import org.eclipse.jpt.jpa.core.internal.context.orm.GenericOrmMappingJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.orm.GenericOrmMappingJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.orm.NullOrmJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericOrmManyToOneRelationship
extends AbstractOrmMappingRelationship<OrmManyToOneMapping>
implements OrmManyToOneRelationship2_0 {
    protected final OrmSpecifiedJoinColumnRelationshipStrategy joinColumnStrategy = this.buildJoinColumnStrategy();
    protected final OrmSpecifiedJoinTableRelationshipStrategy joinTableStrategy = this.buildJoinTableStrategy();

    public GenericOrmManyToOneRelationship(OrmManyToOneMapping parent) {
        super(parent);
        this.strategy = this.buildStrategy();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.joinColumnStrategy.synchronizeWithResourceModel(monitor);
        this.joinTableStrategy.synchronizeWithResourceModel(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.joinColumnStrategy.update(monitor);
        this.joinTableStrategy.update(monitor);
    }

    @Override
    protected SpecifiedRelationshipStrategy buildStrategy() {
        if (this.isJpa2_0Compatible() && this.joinTableStrategy.getJoinTable() != null) {
            return this.joinTableStrategy;
        }
        return this.joinColumnStrategy;
    }

    @Override
    public OrmSpecifiedJoinTableRelationshipStrategy getJoinTableStrategy() {
        return this.joinTableStrategy;
    }

    @Override
    public boolean strategyIsJoinTable() {
        return this.strategy == this.joinTableStrategy;
    }

    @Override
    public void setStrategyToJoinTable() {
        this.joinTableStrategy.addStrategy();
        this.joinColumnStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinTable() {
        return false;
    }

    protected OrmSpecifiedJoinTableRelationshipStrategy buildJoinTableStrategy() {
        return this.isJpa2_0Compatible() ? new GenericOrmMappingJoinTableRelationshipStrategy(this) : new NullOrmJoinTableRelationshipStrategy(this);
    }

    @Override
    public OrmSpecifiedJoinColumnRelationshipStrategy getJoinColumnStrategy() {
        return this.joinColumnStrategy;
    }

    @Override
    public boolean strategyIsJoinColumn() {
        return this.strategy == this.joinColumnStrategy;
    }

    @Override
    public void setStrategyToJoinColumn() {
        this.joinTableStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinColumn() {
        return this.joinTableStrategy.getJoinTable() == null;
    }

    protected OrmSpecifiedJoinColumnRelationshipStrategy buildJoinColumnStrategy() {
        return new GenericOrmMappingJoinColumnRelationshipStrategy(this);
    }

    @Override
    public void initializeOn(OrmMappingRelationship newRelationship) {
        newRelationship.initializeFromJoinColumnRelationship(this);
        newRelationship.initializeFromJoinTableRelationship(this);
    }

    @Override
    public void initializeFromJoinTableRelationship(OrmJoinTableRelationship oldRelationship) {
        super.initializeFromJoinTableRelationship(oldRelationship);
        this.joinTableStrategy.initializeFrom(oldRelationship.getJoinTableStrategy());
    }

    @Override
    public void initializeFromJoinColumnRelationship(OrmJoinColumnRelationship oldRelationship) {
        super.initializeFromJoinColumnRelationship(oldRelationship);
        this.joinColumnStrategy.initializeFrom(oldRelationship.getJoinColumnStrategy());
    }

    @Override
    protected XmlManyToOne getXmlMapping() {
        return (XmlManyToOne)super.getXmlMapping();
    }

    @Override
    public XmlManyToOne getXmlContainer() {
        return this.getXmlMapping();
    }

    @Override
    public boolean isOwner() {
        return true;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return false;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.joinColumnStrategy.validate(messages, reporter);
        this.joinTableStrategy.validate(messages, reporter);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.joinColumnStrategy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.joinTableStrategy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }
}

