/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.disassembly.rulers;

import java.net.URL;
import org.eclipse.cdt.debug.ui.disassembly.rulers.IContributedRulerColumn;
import org.eclipse.cdt.debug.ui.disassembly.rulers.RulerColumnRegistry;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.texteditor.rulers.ExtensionPointHelper;
import org.eclipse.ui.internal.texteditor.rulers.RulerColumnMessages;
import org.eclipse.ui.internal.texteditor.rulers.RulerColumnPlacement;
import org.eclipse.ui.internal.texteditor.rulers.RulerColumnTarget;

public final class RulerColumnDescriptor {
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ENABLED = "enabled";
    private static final String ICON = "icon";
    private static final String GLOBAL = "global";
    private static final String INCLUDE_IN_MENU = "includeInMenu";
    private static final String TARGET_ID = "targetId";
    private static final String TARGET_CLASS = "targetClass";
    private static final String PLACEMENT = "placement";
    private final String fId;
    private final String fName;
    private final ImageDescriptor fIcon;
    private final IConfigurationElement fElement;
    private final RulerColumnTarget fTarget;
    private final RulerColumnPlacement fRulerColumnPlacement;
    private final boolean fDefaultEnablement;
    private final boolean fIsGlobal;
    private final boolean fIncludeInMenu;

    RulerColumnDescriptor(IConfigurationElement element, RulerColumnRegistry registry) throws InvalidRegistryObjectException, CoreException {
        RulerColumnTarget target;
        Assert.isLegal((registry != null ? 1 : 0) != 0);
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fElement = element;
        ExtensionPointHelper helper = new ExtensionPointHelper(element);
        this.fId = helper.getNonNullAttribute(ID);
        this.fName = helper.getDefaultAttribute(NAME, this.fId);
        helper.getNonNullAttribute(CLASS);
        URL iconURL = helper.getDefaultResourceURL(ICON, null);
        this.fIcon = iconURL == null ? null : ImageDescriptor.createFromURL((URL)iconURL);
        this.fDefaultEnablement = helper.getDefaultAttribute(ENABLED, true);
        this.fIsGlobal = helper.getDefaultAttribute(GLOBAL, true);
        this.fIncludeInMenu = helper.getDefaultAttribute(INCLUDE_IN_MENU, true);
        IConfigurationElement[] targetEditors = element.getChildren(TARGET_ID);
        IConfigurationElement[] targetClasses = element.getChildren(TARGET_CLASS);
        RulerColumnTarget combined = null;
        int i = 0;
        while (i < targetEditors.length) {
            IConfigurationElement targetEditor = targetEditors[i];
            target = RulerColumnTarget.createEditorIdTarget((String)new ExtensionPointHelper(targetEditor).getNonNullAttribute(ID));
            combined = RulerColumnTarget.createOrTarget(combined, (RulerColumnTarget)target);
            ++i;
        }
        i = 0;
        while (i < targetClasses.length) {
            IConfigurationElement targetClass = targetClasses[i];
            target = RulerColumnTarget.createClassTarget((String)new ExtensionPointHelper(targetClass).getNonNullAttribute(CLASS));
            combined = RulerColumnTarget.createOrTarget((RulerColumnTarget)combined, (RulerColumnTarget)target);
            ++i;
        }
        this.fTarget = combined;
        IConfigurationElement[] placements = element.getChildren(PLACEMENT);
        switch (placements.length) {
            case 0: {
                this.fRulerColumnPlacement = new RulerColumnPlacement();
                break;
            }
            case 1: {
                this.fRulerColumnPlacement = new RulerColumnPlacement(placements[0]);
                break;
            }
            default: {
                helper.fail(RulerColumnMessages.RulerColumnDescriptor_invalid_placement_msg);
                this.fRulerColumnPlacement = null;
            }
        }
        Assert.isTrue((this.fTarget != null ? 1 : 0) != 0);
        Assert.isTrue((this.fRulerColumnPlacement != null ? 1 : 0) != 0);
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public ImageDescriptor getIcon() {
        return this.fIcon;
    }

    RulerColumnTarget getTarget() {
        return this.fTarget;
    }

    RulerColumnPlacement getPlacement() {
        return this.fRulerColumnPlacement;
    }

    public boolean getDefaultEnablement() {
        return this.fDefaultEnablement;
    }

    public boolean isGlobal() {
        return this.fIsGlobal;
    }

    public boolean isIncludedInMenu() {
        return this.fIncludeInMenu;
    }

    public boolean matchesPart(IWorkbenchPart disassembly) {
        Assert.isLegal((disassembly != null ? 1 : 0) != 0);
        RulerColumnTarget target = this.getTarget();
        IWorkbenchPartSite site = disassembly.getSite();
        if (site != null && target.matchesEditorId(site.getId())) {
            return true;
        }
        if (target.matchesClass(disassembly.getClass())) {
            return true;
        }
        IContentType contentType = this.getContentType(disassembly);
        return contentType != null && target.matchesContentType(contentType);
    }

    public IContributedRulerColumn createColumn(IWorkbenchPart disassembly) throws CoreException, InvalidRegistryObjectException {
        Assert.isLegal((disassembly != null ? 1 : 0) != 0);
        IContributedRulerColumn column = (IContributedRulerColumn)this.fElement.createExecutableExtension(CLASS);
        column.setDescriptor(this);
        column.setDisassemblyPart(disassembly);
        column.columnCreated();
        return column;
    }

    public String toString() {
        return "RulerColumnDescriptor[name=" + this.getName() + "]";
    }

    IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RulerColumnDescriptor other = (RulerColumnDescriptor)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }

    private IContentType getContentType(IWorkbenchPart disassembly) {
        return null;
    }

    String getContributor() {
        try {
            return this.fElement.getContributor().getName();
        }
        catch (InvalidRegistryObjectException e) {
            return "unknown";
        }
    }
}

