/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.scanning.ClassFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageEngineDescriptor;
import org.junit.vintage.engine.discovery.ClassSelectorResolver;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestClass;
import org.junit.vintage.engine.discovery.MethodSelectorResolver;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorPostProcessor;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageDiscoverer {
    private static final IsPotentialJUnit4TestClass isPotentialJUnit4TestClass = new IsPotentialJUnit4TestClass();
    private static final EngineDiscoveryRequestResolver<TestDescriptor> resolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver((Predicate)isPotentialJUnit4TestClass).addSelectorResolver(context -> new ClassSelectorResolver(ClassFilter.of((Predicate)context.getClassNameFilter(), (Predicate)isPotentialJUnit4TestClass))).addSelectorResolver((SelectorResolver)new MethodSelectorResolver()).build();

    public VintageEngineDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        VintageEngineDescriptor engineDescriptor = new VintageEngineDescriptor(uniqueId);
        resolver.resolve(discoveryRequest, (TestDescriptor)engineDescriptor);
        RunnerTestDescriptorPostProcessor postProcessor = new RunnerTestDescriptorPostProcessor();
        for (TestDescriptor testDescriptor : engineDescriptor.getChildren()) {
            RunnerTestDescriptor runnerTestDescriptor = (RunnerTestDescriptor)testDescriptor;
            postProcessor.applyFiltersAndCreateDescendants(runnerTestDescriptor);
        }
        return engineDescriptor;
    }
}

