/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositoryServerProvider;
import org.eclipse.egit.ui.internal.provisional.wizards.RepositoryServerInfo;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class RepositoryLocationContentProvider
implements ITreeContentProvider {
    private Map<RepositoryServerInfo, GitCloneSourceProviderExtension.CloneSourceProvider> parents = new HashMap<RepositoryServerInfo, GitCloneSourceProviderExtension.CloneSourceProvider>();

    RepositoryLocationContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.calculateChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (element instanceof RepositoryServerInfo) {
            return this.parents.get(element);
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        List repositoryImports = (List)inputElement;
        return repositoryImports.toArray(new GitCloneSourceProviderExtension.CloneSourceProvider[0]);
    }

    public Object[] getChildren(Object parentElement) {
        return this.calculateChildren(parentElement);
    }

    private Object[] calculateChildren(Object parentElement) {
        if (parentElement instanceof GitCloneSourceProviderExtension.CloneSourceProvider) {
            GitCloneSourceProviderExtension.CloneSourceProvider repositoryImport = (GitCloneSourceProviderExtension.CloneSourceProvider)parentElement;
            if (repositoryImport.hasFixLocation()) {
                return null;
            }
            Collection<RepositoryServerInfo> repositoryServerInfos = this.getRepositoryServerInfos(repositoryImport);
            if (repositoryServerInfos == null) {
                return null;
            }
            this.cacheParents(repositoryImport, repositoryServerInfos);
            return repositoryServerInfos.toArray(new RepositoryServerInfo[0]);
        }
        return null;
    }

    private Collection<RepositoryServerInfo> getRepositoryServerInfos(GitCloneSourceProviderExtension.CloneSourceProvider repositoryImport) {
        IRepositoryServerProvider repositoryServerProvider;
        Collection<RepositoryServerInfo> repositoryServerInfos = null;
        try {
            repositoryServerProvider = repositoryImport.getRepositoryServerProvider();
        }
        catch (CoreException e) {
            Activator.error(e.getLocalizedMessage(), e);
            return null;
        }
        if (repositoryServerProvider == null) {
            return null;
        }
        try {
            repositoryServerInfos = repositoryServerProvider.getRepositoryServerInfos();
        }
        catch (Exception e) {
            Activator.error(UIText.RepositoryLocationContentProvider_errorProvidingRepoServer, e);
        }
        return repositoryServerInfos;
    }

    private void cacheParents(GitCloneSourceProviderExtension.CloneSourceProvider repositoryImport, Collection<RepositoryServerInfo> repositoryServerInfos) {
        for (RepositoryServerInfo info : repositoryServerInfos) {
            this.parents.put(info, repositoryImport);
        }
    }
}

