/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.plugin;

import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.VersionMatchRule;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class PluginRegistry {
    private PluginRegistry() {
    }

    private static Predicate<IPluginModelBase> asPredicate(PluginFilter filter) {
        return filter != null ? filter::accept : p -> true;
    }

    public static ModelEntry findEntry(String id) {
        return PDECore.getDefault().getModelManager().findEntry(id);
    }

    public static IPluginModelBase findModel(String id) {
        return PDECore.getDefault().getModelManager().findModel(id);
    }

    public static IPluginModelBase findModel(IProject project) {
        return PDECore.getDefault().getModelManager().findModel(project);
    }

    @Deprecated(forRemoval=true, since="3.18 (removal in 2026-06 or later)")
    public static IPluginModelBase findModel(BundleDescription desc) {
        return PluginRegistry.findModel((Resource)desc);
    }

    public static IPluginModelBase findModel(Resource resource) {
        return PDECore.getDefault().getModelManager().findModel(resource);
    }

    public static IPluginModelBase[] getActiveModels() {
        return PluginRegistry.getActiveModels(true);
    }

    public static IPluginModelBase[] getActiveModels(boolean includeFragments) {
        return PDECore.getDefault().getModelManager().getActiveModels(includeFragments);
    }

    public static IPluginModelBase[] getAllModels() {
        return PluginRegistry.getAllModels(true);
    }

    public static IPluginModelBase[] getAllModels(boolean includeFragments) {
        return PDECore.getDefault().getModelManager().getAllModels(includeFragments);
    }

    public static IPluginModelBase[] getWorkspaceModels() {
        return PDECore.getDefault().getModelManager().getWorkspaceModels();
    }

    public static IPluginModelBase[] getExternalModels() {
        return PDECore.getDefault().getModelManager().getExternalModels();
    }

    public static IPluginModelBase findModel(String id, String version, VersionMatchRule matchRule) {
        return PluginRegistry.findModels(id, version, matchRule).findFirst().orElse(null);
    }

    @Deprecated(forRemoval=true, since="3.19 (removal in 2026-09 or later)")
    public static IPluginModelBase findModel(String id, String version, int match, PluginFilter filter) {
        VersionMatchRule rule = PluginRegistry.safeToRuleLiteral(match);
        return PluginRegistry.findModels(id, version, rule).filter(PluginRegistry.asPredicate(filter)).findFirst().orElse(null);
    }

    public static Stream<IPluginModelBase> findModels(String id, String version, VersionMatchRule matchRule) {
        Version reference = version != null ? Version.valueOf((String)version) : null;
        return PluginRegistry.selectModels(id, version != null ? p -> matchRule.matches(VersionUtil.getVersion(p), reference) : null);
    }

    @Deprecated(forRemoval=true, since="3.19 (removal in 2026-09 or later)")
    public static IPluginModelBase[] findModels(String id, String version, int match, PluginFilter filter) {
        VersionMatchRule rule = PluginRegistry.safeToRuleLiteral(match);
        return (IPluginModelBase[])PluginRegistry.findModels(id, version, rule).filter(PluginRegistry.asPredicate(filter)).toArray(IPluginModelBase[]::new);
    }

    private static VersionMatchRule safeToRuleLiteral(int match) {
        VersionMatchRule rule;
        try {
            rule = VersionUtil.matchRuleFromLiteral(match);
        }
        catch (IllegalArgumentException e) {
            rule = VersionMatchRule.PERFECT;
        }
        return rule;
    }

    public static IPluginModelBase findModel(String id, org.osgi.framework.VersionRange range) {
        return PluginRegistry.findModels(id, range).findFirst().orElse(null);
    }

    @Deprecated(forRemoval=true, since="3.19 (removal in 2026-09 or later)")
    public static IPluginModelBase findModel(String id, VersionRange range, PluginFilter filter) {
        return PluginRegistry.findModels(id, (org.osgi.framework.VersionRange)range).filter(PluginRegistry.asPredicate(filter)).findFirst().orElse(null);
    }

    public static Stream<IPluginModelBase> findModels(String id, org.osgi.framework.VersionRange range) {
        return PluginRegistry.selectModels(id, range != null ? p -> range.includes(VersionUtil.getVersion(p)) : null);
    }

    @Deprecated(forRemoval=true, since="3.19 (removal in 2026-09 or later)")
    public static IPluginModelBase[] findModels(String id, VersionRange range, PluginFilter filter) {
        return (IPluginModelBase[])PluginRegistry.findModels(id, (org.osgi.framework.VersionRange)range).filter(PluginRegistry.asPredicate(filter)).toArray(IPluginModelBase[]::new);
    }

    private static Stream<IPluginModelBase> selectModels(String id, Predicate<IPluginModelBase> versionFilter) {
        ModelEntry entry = PluginRegistry.findEntry(id);
        if (entry == null) {
            return Stream.empty();
        }
        ArrayList<IPluginModelBase> models = entry.hasWorkspaceModels() ? entry.fWorkspaceEntries : entry.fExternalEntries;
        Stream<IPluginModelBase> plugins = models.stream().filter(m -> {
            IPluginBase base = m.getPluginBase();
            return base != null && base.getId() != null;
        });
        if (versionFilter != null) {
            plugins = plugins.filter(versionFilter);
        }
        return plugins.sorted(VersionUtil.BY_DESCENDING_PLUGIN_VERSION);
    }

    public static IBuildModel createBuildModel(IPluginModelBase model) throws CoreException {
        IFile buildFile;
        IProject project;
        IResource resource;
        if (model != null && (resource = model.getUnderlyingResource()) != null && (project = resource.getProject()) != null && (buildFile = PDEProject.getBuildProperties(project)).exists()) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
            return buildModel;
        }
        return null;
    }

    @Deprecated(forRemoval=true, since="3.19 (removal in 2026-09 or later)")
    public static class PluginFilter {
        public boolean accept(IPluginModelBase model) {
            return true;
        }
    }
}

