/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.pde.bnd.ui.LabelParser;

public class HierarchicalLabel<T> {
    private static final String DELIMITER_FOR_HIERARCHY = " :: ";
    private final List<String> labels;
    private final Function<HierarchicalLabel<T>, T> leafActionCallback;
    boolean enabled = true;
    boolean checked = false;
    String description = null;

    public HierarchicalLabel(String compoundLabel, Function<HierarchicalLabel<T>, T> leafNodeAction) {
        this.leafActionCallback = leafNodeAction;
        if (compoundLabel == null || compoundLabel.trim().isEmpty()) {
            throw new IllegalArgumentException("Label string cannot be null or empty.");
        }
        LabelParser parsedEntry = new LabelParser(compoundLabel);
        this.enabled = parsedEntry.isEnabled();
        this.checked = parsedEntry.isChecked();
        this.description = parsedEntry.getDescription();
        String label = parsedEntry.getLabel();
        this.labels = new ArrayList<String>(Arrays.asList(label.split(DELIMITER_FOR_HIERARCHY)));
    }

    public T getLeafAction() {
        return this.leafActionCallback.apply(this);
    }

    public int getNumLLevels() {
        return this.labels.size();
    }

    public String getByPosition(int position) {
        if (position < 0 || position >= this.labels.size()) {
            throw new IllegalArgumentException("Position out of bounds.");
        }
        return this.labels.get(position);
    }

    public String getFirst() {
        return this.labels.get(0);
    }

    public String getLeaf() {
        return this.labels.get(this.labels.size() - 1);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public String toString() {
        return String.join((CharSequence)DELIMITER_FOR_HIERARCHY, this.labels);
    }
}

