/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.p2;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.annotations.TaskChainMenuEntry;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.core.ui.annotations.TaskChainUiInit;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.AbstractProductBuild;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.DynamicProductBuildRegistry;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.ProductBuildRegistry;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.tasks.jar.TaskInitJarCache;
import org.osgi.service.component.annotations.Component;

@TaskChain.TaskChainId(description="Export Products...", alias={"ProductBuildTaskChain"})
@TaskChainMenuEntry(path={"Others", "TEA Build Library"}, groupingId="tea.misc.group", icon="icons/product_xml_obj.png")
@Component
public class ProductBuildTaskChain
implements TaskChain {
    private static final String DUMMY_SITE = "dummy-site";
    protected List<AbstractProductBuild> builds = new ArrayList<AbstractProductBuild>();

    public ProductBuildTaskChain() {
    }

    public ProductBuildTaskChain(AbstractProductBuild ... build) {
        this.builds.addAll(Arrays.asList(build));
    }

    @TaskChainUiInit
    public void selectProducts(Shell parent, DynamicProductBuildRegistry reg) {
        this.builds.clear();
        ProductSelectionDialog dlg = new ProductSelectionDialog(parent, reg);
        if (dlg.open() != 0) {
            throw new OperationCanceledException();
        }
        this.builds.addAll(dlg.getBuilds());
        if (this.builds.isEmpty()) {
            throw new OperationCanceledException();
        }
    }

    @TaskChainContextInit
    public void init(TaskExecutionContext c, TaskingLog log, TeaBuildConfig cfg, DynamicProductBuildRegistry registry, BuildDirectories dirs) {
        TaskInitJarCache cache = new TaskInitJarCache(dirs.getNewCacheDirectory("jar"));
        c.addTask((Object)cache);
        if (this.builds.isEmpty()) {
            List productList;
            List list = productList = cfg.productsToExport == null ? Collections.emptyList() : Splitter.on((char)',').splitToList((CharSequence)cfg.productsToExport);
            if (productList.isEmpty()) {
                log.error("Product list is empty nothing to build");
            }
            for (String product : productList) {
                AbstractProductBuild productBuild = registry.findProductBuild(product);
                if (productBuild != null) {
                    this.addProductBuildTasks(c, log, productBuild);
                    continue;
                }
                log.error("Cannot build product:" + product + " . Product not found.");
            }
        } else {
            for (AbstractProductBuild build : this.builds) {
                this.addProductBuildTasks(c, log, build);
            }
        }
        c.addTask(cache.getCleanup());
    }

    private void addProductBuildTasks(TaskExecutionContext c, TaskingLog log, AbstractProductBuild productBuild) {
        productBuild.addUpdateSiteTasks(c, new String[]{DUMMY_SITE});
        productBuild.addProductTasks(c, DUMMY_SITE);
    }

    public static final class ProductSelectionDialog
    extends TitleAreaDialog {
        private CheckboxTableViewer tv;
        private List<AbstractProductBuild> selected;
        private final ProductBuildRegistry registry;

        public ProductSelectionDialog(Shell parentShell, ProductBuildRegistry registry) {
            super(parentShell);
            this.registry = registry;
        }

        protected Point getInitialSize() {
            return new Point(450, 350);
        }

        protected Control createDialogArea(Composite parent) {
            GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
            this.getShell().setText("Product Export");
            this.setTitle("Select the products to export");
            this.setMessage("The selected products will be exported to zip files.", 1);
            this.tv = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tv.getControl());
            this.tv.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tv.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LblProvider()));
            ArrayList<AbstractProductBuild> input = new ArrayList<AbstractProductBuild>(this.registry.getAllProducts());
            input.sort((a, b) -> a.getDescription().compareTo(b.getDescription()));
            this.tv.setInput(input);
            return parent;
        }

        protected void okPressed() {
            this.selected = Arrays.stream(this.tv.getCheckedElements()).map(AbstractProductBuild.class::cast).collect(Collectors.toList());
            super.okPressed();
        }

        public Collection<? extends AbstractProductBuild> getBuilds() {
            return this.selected;
        }

        private static final class LblProvider
        extends BaseLabelProvider
        implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
            private LblProvider() {
            }

            public StyledString getStyledText(Object element) {
                AbstractProductBuild b = (AbstractProductBuild)element;
                StyledString result = new StyledString(b.getDescription());
                result.append(" - ", StyledString.DECORATIONS_STYLER);
                result.append(Arrays.stream(b.getPlatformsToBuild()).map(this::platformLabel).collect(Collectors.joining(", ")), StyledString.DECORATIONS_STYLER);
                return result;
            }

            private String platformLabel(PlatformTriple triple) {
                if (triple == PlatformTriple.WIN32) {
                    return "win32";
                }
                if (triple == PlatformTriple.WIN64) {
                    return "win64";
                }
                if (triple == PlatformTriple.LINUX32) {
                    return "linux32";
                }
                if (triple == PlatformTriple.LINUX64) {
                    return "linux64";
                }
                return "<unknown>";
            }

            public Image getImage(Object element) {
                return null;
            }
        }
    }
}

