/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.intermediate.filters;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.CommandSequence;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Command;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.CreateCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DisposeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.TransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.filters.StreamingFilter;

public class AbsoluteToRelativeTransformsFilter
extends StreamingFilter {
    private final Stack<AffineTransform> transforms = new Stack();

    public AbsoluteToRelativeTransformsFilter(CommandSequence stream) {
        super(stream);
    }

    @Override
    public Command<?> next() {
        Object nextCommand = super.next();
        if (nextCommand instanceof AffineTransformCommand) {
            AffineTransformCommand affineTransformCommand = (AffineTransformCommand)nextCommand;
            this.getCurrentTransform().concatenate((AffineTransform)affineTransformCommand.getValue());
        } else if (nextCommand instanceof CreateCommand) {
            AffineTransform newTransform = this.transforms.isEmpty() ? new AffineTransform() : new AffineTransform(this.getCurrentTransform());
            this.transforms.push(newTransform);
        } else if (nextCommand instanceof DisposeCommand) {
            this.transforms.pop();
        }
        return nextCommand;
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (command instanceof SetTransformCommand) {
            SetTransformCommand setTransformCommand = (SetTransformCommand)command;
            AffineTransform absoluteTransform = (AffineTransform)setTransformCommand.getValue();
            AffineTransform relativeTransform = new AffineTransform();
            try {
                AffineTransform invertedOldTransformation = this.getCurrentTransform().createInverse();
                relativeTransform.concatenate(invertedOldTransformation);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
            relativeTransform.concatenate(absoluteTransform);
            TransformCommand transformCommand = new TransformCommand(relativeTransform);
            return Collections.singletonList(transformCommand);
        }
        return Collections.singletonList(command);
    }

    private AffineTransform getCurrentTransform() {
        return this.transforms.peek();
    }
}

