/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.core;

import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.TransformLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.events.StructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.grid.core.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.print.PrintEntireGridCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOffCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOnCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.CellSelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.core.DimSelectionEvent;
import org.eclipse.statet.ecommons.waltable.viewport.core.RecalculateScrollBarsCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.ScrollEvent;
import org.eclipse.statet.ecommons.waltable.viewport.core.ScrollPageCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.ScrollStepCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.SelectRelativePageCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.ShowCellInViewportCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.ShowDimPositionInViewportCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportDragCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDimImpl;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportSelectDimPositionsCommandHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class ViewportLayer
extends TransformLayer<ViewportLayerDim> {
    static final int EDGE_HOVER_REGION_SIZE = 16;
    static final int PAGE_INTERSECTION_SIZE = 16;
    private final Layer scrollableLayer;
    private boolean viewportOff = false;
    private final long[] savedOriginPixel = new long[2];
    private MoveViewportRunnable edgeHoverRunnable;

    public ViewportLayer(Layer underlyingLayer) {
        super(underlyingLayer);
        this.scrollableLayer = underlyingLayer;
        this.init();
        this.registerCommandHandlers();
    }

    @Override
    protected ViewportLayerDimImpl createDim(Orientation orientation) {
        Layer scrollable = this.getScrollableLayer();
        return new ViewportLayerDimImpl(this, scrollable.getDim(orientation));
    }

    @Override
    public void dispose() {
        super.dispose();
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            this.disposeDim(orientation);
            ++n2;
        }
        this.cancelEdgeHoverScroll();
    }

    public boolean isViewportOff() {
        return this.viewportOff;
    }

    protected void disposeDim(Orientation orientation) {
        ViewportLayerDimImpl dim = this.get(orientation);
        if (dim != null) {
            dim.dispose();
        }
    }

    @Override
    public ViewportLayerDim getDim(Orientation orientation) {
        return (ViewportLayerDim)super.getDim(orientation);
    }

    final ViewportLayerDimImpl get(Orientation orientation) {
        return (ViewportLayerDimImpl)super.getDim(orientation);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RecalculateScrollBarsCommandHandler(this));
        this.registerCommandHandler(new ShowCellInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowDimPositionInViewportCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectDimPositionsCommandHandler(this));
        this.registerCommandHandler(new ViewportDragCommandHandler(this));
        this.registerCommandHandler(new SelectRelativePageCommandHandler(this));
        this.registerCommandHandler(new ScrollStepCommandHandler(this));
        this.registerCommandHandler(new ScrollPageCommandHandler(this));
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        return super.getCellByPosition(columnPosition, rowPosition);
    }

    protected void fireScrollEvent() {
        this.fireLayerEvent(new ScrollEvent(this));
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command.cloneCommand();
            long widthDiff = (long)clientAreaResizeCommand.getScrollable().getClientArea().width - clientAreaResizeCommand.getCalcArea().width;
            long heightDiff = (long)clientAreaResizeCommand.getScrollable().getClientArea().height - clientAreaResizeCommand.getCalcArea().height;
            this.get(Orientation.HORIZONTAL).checkScrollBar(clientAreaResizeCommand.getScrollable());
            this.get(Orientation.VERTICAL).checkScrollBar(clientAreaResizeCommand.getScrollable());
            this.get(Orientation.HORIZONTAL).handleResize();
            this.get(Orientation.VERTICAL).handleResize();
            LRectangle possibleArea = SwtUtils.toNatTable(clientAreaResizeCommand.getScrollable().getClientArea());
            possibleArea.width -= widthDiff;
            possibleArea.height -= heightDiff;
            clientAreaResizeCommand.setCalcArea(possibleArea);
            return super.doCommand(clientAreaResizeCommand);
        }
        if (command instanceof TurnViewportOffCommand) {
            if (!this.isViewportOff()) {
                Orientation[] orientationArray = Orientation.values();
                int n = orientationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Orientation orientation = orientationArray[n2];
                    this.savedOriginPixel[orientation.ordinal()] = this.get(orientation).getOriginPixel();
                    ++n2;
                }
                this.viewportOff = true;
                this.fireScrollEvent();
            }
            return true;
        }
        if (command instanceof TurnViewportOnCommand) {
            if (this.isViewportOff()) {
                this.viewportOff = false;
                Orientation[] orientationArray = Orientation.values();
                int n = orientationArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Orientation orientation = orientationArray[n3];
                    this.get(orientation).doSetOriginPixel(this.savedOriginPixel[orientation.ordinal()]);
                    ++n3;
                }
                this.fireScrollEvent();
            }
            return true;
        }
        if (command instanceof PrintEntireGridCommand) {
            this.get(Orientation.HORIZONTAL).movePositionIntoViewport(0L);
            this.get(Orientation.VERTICAL).movePositionIntoViewport(0L);
        }
        return super.doCommand(command);
    }

    public void recalculateScrollBars() {
        this.get(Orientation.HORIZONTAL).handleResize();
        this.get(Orientation.VERTICAL).handleResize();
    }

    @Override
    public void handleLayerEvent(LayerEvent event) {
        if (event instanceof StructuralChangeEvent) {
            StructuralChangeEvent structuralChangeEvent = (StructuralChangeEvent)event;
            Orientation[] orientationArray = Orientation.values();
            int n = orientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Orientation orientation = orientationArray[n2];
                if (structuralChangeEvent.isStructureChanged(orientation)) {
                    ViewportLayerDimImpl dim = this.get(orientation);
                    dim.handleStructuralChange(structuralChangeEvent.getDiffs(orientation));
                }
                ++n2;
            }
        }
        if (event instanceof CellSelectionEvent) {
            this.processSelection((CellSelectionEvent)event);
        } else if (event instanceof DimSelectionEvent) {
            this.processDimSelection((DimSelectionEvent)event);
        }
        super.handleLayerEvent(event);
    }

    private void processSelection(CellSelectionEvent selectionEvent) {
        if (selectionEvent.getRevealCell()) {
            this.get(Orientation.HORIZONTAL).movePositionIntoViewport(selectionEvent.getColumnPosition());
            this.get(Orientation.VERTICAL).movePositionIntoViewport(selectionEvent.getRowPosition());
        }
    }

    private void processDimSelection(DimSelectionEvent selectionEvent) {
        long explicitePosition = selectionEvent.getPositionToReveal();
        if (explicitePosition >= 0L) {
            this.get(selectionEvent.getOrientation()).movePositionIntoViewport(explicitePosition);
        }
    }

    public Layer getScrollableLayer() {
        return this.scrollableLayer;
    }

    @Override
    public String toString() {
        return "Viewport Layer";
    }

    public void drag(long x, long y) {
        if (x < 0L && y < 0L) {
            this.cancelEdgeHoverScroll();
            return;
        }
        MoveViewportRunnable move = this.edgeHoverRunnable;
        if (move == null) {
            move = new MoveViewportRunnable();
        }
        move.fast = true;
        boolean requireSchedule = false;
        LRectangle clientArea = this.getClientAreaProvider().getClientArea();
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            LRange lRange = clientArea.getRange(orientation);
            long pixel = orientation == Orientation.HORIZONTAL ? x : y;
            int change = 0;
            if (pixel >= lRange.start && pixel < lRange.start + 16L) {
                change = -1;
                if (pixel >= lRange.start + 8L) {
                    move.fast = false;
                }
            } else if (pixel >= lRange.end - 16L && pixel < lRange.end) {
                change = 1;
                if (pixel < lRange.end - 8L) {
                    move.fast = false;
                }
            }
            move.change[orientation.ordinal()] = change;
            requireSchedule |= change != 0;
            ++n2;
        }
        if (requireSchedule) {
            move.schedule();
        } else {
            this.cancelEdgeHoverScroll();
        }
    }

    private void cancelEdgeHoverScroll() {
        this.edgeHoverRunnable = null;
    }

    class MoveViewportRunnable
    implements Runnable {
        private final int[] change = new int[2];
        private boolean fast;
        private final Display display = Display.getCurrent();

        public void schedule() {
            if (ViewportLayer.this.edgeHoverRunnable != this) {
                ViewportLayer.this.edgeHoverRunnable = this;
                this.display.timerExec(500, (Runnable)this);
            }
        }

        @Override
        public void run() {
            if (ViewportLayer.this.edgeHoverRunnable != this) {
                return;
            }
            Orientation[] orientationArray = Orientation.values();
            int n = orientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Orientation orientation = orientationArray[n2];
                switch (this.change[orientation.ordinal()]) {
                    case -1: {
                        ViewportLayer.this.get(orientation).scrollBackwardByPosition();
                        break;
                    }
                    case 1: {
                        ViewportLayer.this.get(orientation).scrollForwardByPosition();
                    }
                }
                ++n2;
            }
            this.display.timerExec(this.fast ? 100 : 500, (Runnable)this);
        }
    }
}

