/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.gui;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.edit.DialogEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.EditTypeEnum;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.gui.ICellEditDialog;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CellEditDialog
extends Dialog
implements ICellEditDialog {
    protected final Object originalCanonicalValue;
    protected final ICellEditor cellEditor;
    protected DialogEditHandler cellEditHandler = new DialogEditHandler();
    protected final LayerCell cell;
    protected final ConfigRegistry configRegistry;
    protected Map<String, Object> editDialogSettings;

    public CellEditDialog(Shell parentShell, Object originalCanonicalValue, LayerCell cell, ICellEditor cellEditor, ConfigRegistry configRegistry) {
        super(parentShell);
        this.originalCanonicalValue = originalCanonicalValue;
        this.cell = cell;
        this.cellEditor = cellEditor;
        this.configRegistry = configRegistry;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String shellTitle = Messages.getString("CellEditDialog.shellTitle");
        Image shellIcon = GUIHelper.getImage("editor");
        if (this.editDialogSettings != null) {
            Object settingsShellImage;
            if (this.editDialogSettings.containsKey("DIALOG_SHELL_TITLE")) {
                String settingsShellTitle;
                shellTitle = settingsShellTitle = this.editDialogSettings.get("DIALOG_SHELL_TITLE").toString();
            }
            if ((settingsShellImage = this.editDialogSettings.get("DIALOG_SHELL_ICON")) != null && settingsShellImage instanceof Image) {
                shellIcon = (Image)settingsShellImage;
            }
        }
        newShell.setText(shellTitle);
        newShell.setImage(shellIcon);
    }

    protected boolean isResizable() {
        return false;
    }

    protected Point getInitialLocation(Point initialSize) {
        Object settingsLocation;
        if (this.editDialogSettings != null && (settingsLocation = this.editDialogSettings.get("DIALOG_SHELL_LOCATION")) != null && settingsLocation instanceof Point) {
            return (Point)settingsLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Object settingsSize;
        if (this.editDialogSettings != null && (settingsSize = this.editDialogSettings.get("DIALOG_SHELL_SIZE")) != null && settingsSize instanceof Point) {
            return (Point)settingsSize;
        }
        return super.getInitialSize();
    }

    protected void okPressed() {
        if (this.cellEditor.commit(null, true)) {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.cellEditor.close();
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        GridLayout panelLayout = new GridLayout(1, true);
        panelLayout.marginWidth = 8;
        panel.setLayout((Layout)panelLayout);
        if (this.editDialogSettings != null && this.editDialogSettings.containsKey("DIALOG_MESSAGE")) {
            String customMessage = this.editDialogSettings.get("DIALOG_MESSAGE").toString();
            Label customMessageLabel = new Label(panel, 0);
            customMessageLabel.setText(customMessage);
            GridDataFactory.fillDefaults().grab(true, false).hint(100, 20).applyTo((Control)customMessageLabel);
        }
        this.cellEditor.activateCell(panel, this.originalCanonicalValue, EditMode.DIALOG, this.cellEditHandler, this.cell, this.configRegistry);
        Control editorControl = this.cellEditor.getEditorControl();
        editorControl.addKeyListener(this.getEscKeyListener());
        if (editorControl.getLayoutData() == null) {
            GridDataFactory.fillDefaults().grab(true, false).hint(100, 20).applyTo(editorControl);
        }
        return panel;
    }

    @Override
    public Object getCommittedValue() {
        return this.cellEditHandler.getCommittedValue();
    }

    @Override
    public EditTypeEnum getEditType() {
        return EditTypeEnum.SET;
    }

    @Override
    public Object calculateValue(Object currentValue, Object processValue) {
        return processValue;
    }

    protected KeyListener getEscKeyListener() {
        return new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    CellEditDialog.this.cancelPressed();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    CellEditDialog.this.cancelPressed();
                }
            }
        };
    }

    @Override
    public void setDialogSettings(Map<String, Object> editDialogSettings) {
        Object settingsResizable;
        this.editDialogSettings = editDialogSettings;
        if (this.editDialogSettings != null && (settingsResizable = this.editDialogSettings.get("DIALOG_SHELL_RESIZABLE")) != null && settingsResizable instanceof Boolean) {
            if (((Boolean)settingsResizable).booleanValue()) {
                this.setShellStyle(0x10C70 | CellEditDialog.getDefaultOrientation());
            } else {
                this.setShellStyle(0x10860 | CellEditDialog.getDefaultOrientation());
            }
        }
    }
}

