/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import org.eclipse.statet.dsl.core.source.ast.Comment;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslParser;
import org.eclipse.statet.dsl.core.source.ast.Dummy;
import org.eclipse.statet.dsl.core.source.ast.NContainer;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.ScannerImpl;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SyntaxProblem;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AliasToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AnchorToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.CommentType;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DirectiveToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarStyle;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagTuple;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Token;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.yaml.core.source.ast.Alias;
import org.eclipse.statet.yaml.core.source.ast.Anchor;
import org.eclipse.statet.yaml.core.source.ast.MapEntry;
import org.eclipse.statet.yaml.core.source.ast.PropertiesContainer;
import org.eclipse.statet.yaml.core.source.ast.SeqEntry;
import org.eclipse.statet.yaml.core.source.ast.YamlAsts;
import org.eclipse.statet.yaml.core.source.ast.YamlCollection;
import org.eclipse.statet.yaml.core.source.ast.YamlDirective;
import org.eclipse.statet.yaml.core.source.ast.YamlDocument;
import org.eclipse.statet.yaml.core.source.ast.YamlMarker;
import org.eclipse.statet.yaml.core.source.ast.YamlScalar;
import org.eclipse.statet.yaml.core.source.ast.YamlTag;

@NonNullByDefault
public class YamlParser
extends DslParser {
    public static final int COLLECT_COMMENTS = 1;
    private final ScannerImpl lexer = new ScannerImpl(true, false, false){

        @Override
        protected void handleComment(CommentType type, int startIndex, int endIndex) {
            if (YamlParser.this.getCommentLevel() != 0) {
                YamlParser.this.addComment(new Comment(startIndex, endIndex));
            }
        }
    };

    public YamlParser(int level) {
        super(level);
    }

    public String getSyntaxLabel() {
        return "YAML";
    }

    public void setScalarText(boolean create) {
        this.lexer.setCreateContentText(create);
    }

    protected void initTask() {
        super.initTask();
        this.lexer.reset(this.getParseInput());
    }

    protected boolean isNodeProperty(DslAstNode node) {
        return YamlAsts.PROPERTY_TYPES.contains(node.getNodeType());
    }

    protected void exit(int offset) {
        super.exit(offset);
        if (this.getDepth() == 1) {
            this.lexer.resetToRoot();
        }
    }

    private boolean exitTo1(Class<?> type1, Class<?> type2) {
        while (this.getDepth() > 1) {
            DslAstNode currentNode = this.getCurrentNode();
            if (currentNode.getClass() == type1 || currentNode.getClass() == type2) {
                return true;
            }
            if (currentNode.getNodeType() != NodeType.KEY_VALUE_ENTRY) break;
            this.exit(Integer.MIN_VALUE);
        }
        int checkDepth = this.getDepth() - 1;
        DslAstNode node = this.getCurrentNode().getDslParent();
        while (checkDepth > 1) {
            if (node.getClass() == type1 || node.getClass() == type2) {
                while (this.getDepth() > checkDepth) {
                    this.exit(Integer.MIN_VALUE);
                }
                return true;
            }
            --checkDepth;
            node = node.getDslParent();
        }
        return false;
    }

    private void ensureRecordContent(int startOffset) {
        switch (this.getRecordState()) {
            case 0: {
                YamlDocument recordNode = new YamlDocument((SourceComponent)this.getCurrentNode(), startOffset);
                this.enterNode((NContainer)recordNode);
                this.beginRecordContent(recordNode);
                return;
            }
            case 1: {
                YamlDocument recordNode = (YamlDocument)this.getCurrentNode();
                if (!this.getCurrentContainerBuilder().children.isEmpty()) {
                    Dummy marker = new Dummy(4330256, (DslAstNode)recordNode, startOffset);
                    this.addChildTerm((DslAstNode)marker);
                    recordNode.directivesEndChild = marker;
                }
                this.beginRecordContent(recordNode);
                return;
            }
        }
    }

    private DslAstNode checkParent(Token token) {
        this.ensureRecordContent(token.getStartIndex());
        DslAstNode currentNode = this.getCurrentNode();
        switch (currentNode.getNodeType()) {
            case SEQ: {
                if (currentNode.getOperator() == '-') {
                    SeqEntry seqEntry = new SeqEntry(0x440330, currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode(seqEntry);
                    return seqEntry;
                }
                return currentNode;
            }
            case MAP: {
                MapEntry mapEntry = new MapEntry(currentNode.getOperator() == '?' ? 0x444330 : 0, currentNode, token.getStartIndex(), token.getEndIndex());
                this.enterNode(mapEntry);
                return mapEntry;
            }
        }
        return currentNode;
    }

    private void addChildTerm(DslAstNode node) {
        this.addChild(node);
        this.checkExit();
    }

    protected void parseInput(SourceComponent sourceNode) {
        Token token;
        block42: while ((token = this.lexer.nextToken()) != null) {
            switch (token.getTokenId()) {
                case StreamEnd: 
                case StreamStart: {
                    continue block42;
                }
                case Directive: {
                    YamlDocument docNode;
                    DslAstNode currentNode = this.getCurrentNode();
                    switch (this.getRecordState()) {
                        case 0: {
                            docNode = new YamlDocument((SourceComponent)currentNode, token.getStartIndex());
                            this.enterNode((NContainer)docNode);
                            this.beginRecordDirectives(docNode);
                            break;
                        }
                        case 1: {
                            docNode = (YamlDocument)currentNode;
                            break;
                        }
                        default: {
                            currentNode = this.exitToSourceComponent(token.getStartIndex());
                            docNode = null;
                        }
                    }
                    Object node = new YamlDirective(currentNode, token.getStartIndex(), token.getEndIndex(), ((DirectiveToken)token).getName());
                    this.addChildTerm((DslAstNode)node);
                    if (docNode != null) {
                        this.attachProblem((DslAstNode)node, token);
                        continue block42;
                    }
                    this.setStatus((DslAstNode)node, 0x400200, null);
                    continue block42;
                }
                case DocumentStart: {
                    YamlDocument docNode;
                    DslAstNode currentNode = this.getCurrentNode();
                    switch (this.getRecordState()) {
                        case 1: {
                            docNode = (YamlDocument)currentNode;
                            break;
                        }
                        default: {
                            currentNode = this.exitToSourceComponent(token.getStartIndex());
                            docNode = new YamlDocument((SourceComponent)currentNode, token.getStartIndex());
                            this.enterNode((NContainer)docNode);
                        }
                    }
                    YamlMarker marker = new YamlMarker.DirectivesEnd(docNode, token.getStartIndex(), token.getEndIndex());
                    this.addChildTerm((DslAstNode)marker);
                    this.attachProblem((DslAstNode)marker, token);
                    docNode.directivesEndChild = marker;
                    this.beginRecordContent(docNode);
                    continue block42;
                }
                case DocumentEnd: {
                    DslAstNode currentNode = this.getCurrentNode();
                    YamlDocument docNode = switch (this.getRecordState()) {
                        case 0 -> null;
                        case 1 -> (YamlDocument)currentNode;
                        default -> {
                            currentNode = this.exitToRecord();
                            yield (YamlDocument)currentNode;
                        }
                    };
                    YamlMarker marker = new YamlMarker.DocumentEnd(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.addChildTerm((DslAstNode)marker);
                    this.attachProblem((DslAstNode)marker, token);
                    if (docNode == null) continue block42;
                    docNode.endChild = marker;
                    this.endRecord(docNode, marker.getEndOffset());
                    continue block42;
                }
                case BlockSequenceStart: {
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    YamlCollection.BlockSeq node = new YamlCollection.BlockSeq(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode((NContainer)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case BlockMappingStart: {
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    YamlCollection.BlockMap node = new YamlCollection.BlockMap(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode((NContainer)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case BlockEnd: {
                    boolean found = this.exitTo(YamlCollection.BlockSeq.class, YamlCollection.BlockMap.class);
                    if (!found) continue block42;
                    this.exit(token.getEndIndex());
                    continue block42;
                }
                case FlowSequenceStart: {
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    YamlCollection.FlowSeq node = new YamlCollection.FlowSeq(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode((NContainer)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case FlowSequenceEnd: {
                    boolean found = this.exitTo(YamlCollection.FlowSeq.class);
                    DslAstNode currentNode = this.getCurrentNode();
                    if (found) {
                        YamlCollection.FlowSeq yamlCollection = (YamlCollection.FlowSeq)currentNode;
                        yamlCollection.closeIndicatorOffset = token.getStartIndex();
                        this.exit(token.getEndIndex());
                        continue block42;
                    }
                    this.addChildTerm((DslAstNode)new Dummy(0x400200, currentNode, token.getStartIndex(), token.getEndIndex()));
                    continue block42;
                }
                case FlowMappingStart: {
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    YamlCollection.FlowMap node = new YamlCollection.FlowMap(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode((NContainer)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case FlowMappingEnd: {
                    Object node;
                    boolean found = this.exitTo(YamlCollection.FlowMap.class);
                    DslAstNode currentNode = this.getCurrentNode();
                    if (found) {
                        node = (YamlCollection.FlowMap)currentNode;
                        node.closeIndicatorOffset = token.getStartIndex();
                        this.exit(token.getEndIndex());
                        continue block42;
                    }
                    this.addChildTerm((DslAstNode)new Dummy(0x400200, currentNode, token.getStartIndex(), token.getEndIndex()));
                    continue block42;
                }
                case BlockEntry: {
                    YamlCollection.BlockSeq seqNode;
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    if (currentNode instanceof PropertiesContainer && currentNode.getDslParent() instanceof SeqEntry) {
                        this.exit(Integer.MIN_VALUE);
                        currentNode = this.getCurrentNode();
                    }
                    if (currentNode instanceof YamlCollection.BlockSeq) {
                        seqNode = (YamlCollection.BlockSeq)currentNode;
                    } else if (currentNode instanceof SeqEntry) {
                        this.exit(Integer.MIN_VALUE);
                        seqNode = (YamlCollection.BlockSeq)this.getCurrentNode();
                    } else {
                        seqNode = new YamlCollection.BlockSeq(currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode((NContainer)seqNode);
                    }
                    Object node = new SeqEntry((DslAstNode)seqNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode((org.eclipse.statet.dsl.core.source.ast.SeqEntry)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case FlowEntry: {
                    YamlTag node;
                    this.ensureRecordContent(token.getStartIndex());
                    boolean found = this.exitTo1(YamlCollection.FlowSeq.class, YamlCollection.FlowMap.class);
                    DslAstNode currentNode = this.getCurrentNode();
                    if (found) {
                        DslParser.NContainerBuilder builder = this.getCurrentContainerBuilder();
                        if (currentNode.getStatusCode() == 0 && builder.sepOffsets.size() == builder.children.size()) {
                            node = switch (currentNode.getNodeType()) {
                                case NodeType.SEQ -> new Dummy(4457248, currentNode, token.getStartIndex());
                                case NodeType.MAP -> new Dummy(4465440, currentNode, token.getStartIndex());
                                default -> throw new RuntimeException();
                            };
                            this.addChildTerm((DslAstNode)node);
                        }
                        builder.sepOffsets.add(token.getStartIndex());
                        continue block42;
                    }
                    this.addChildTerm((DslAstNode)new Dummy(0x440200, currentNode, token.getStartIndex(), token.getEndIndex()));
                    continue block42;
                }
                case Anchor: {
                    PropertiesContainer propertiesNode;
                    DslAstNode currentNode = this.checkParent(token);
                    if (currentNode.getNodeType() == NodeType.PROPERTIES_CONTAINER) {
                        propertiesNode = (PropertiesContainer)currentNode;
                    } else {
                        propertiesNode = new PropertiesContainer(currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode(propertiesNode);
                    }
                    Object node = new Anchor((DslAstNode)propertiesNode, token.getStartIndex(), token.getEndIndex(), ((AnchorToken)token).getValue());
                    this.addChildTerm((DslAstNode)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case Alias: {
                    DslAstNode currentNode = this.checkParent(token);
                    Alias node = new Alias(currentNode, token.getStartIndex(), token.getEndIndex(), ((AliasToken)token).getValue());
                    this.addChildTerm((DslAstNode)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case Tag: {
                    PropertiesContainer propertiesNode;
                    TagTuple tagTuple = ((TagToken)token).getValue();
                    DslAstNode currentNode = this.checkParent(token);
                    if (currentNode instanceof PropertiesContainer) {
                        propertiesNode = (PropertiesContainer)currentNode;
                    } else {
                        propertiesNode = new PropertiesContainer(currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode(propertiesNode);
                    }
                    YamlTag node = new YamlTag((DslAstNode)propertiesNode, token.getStartIndex(), token.getEndIndex(), tagTuple.getHandle(), tagTuple.getSuffix());
                    this.addChildTerm((DslAstNode)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
                case Key: {
                    boolean found;
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    if (currentNode instanceof YamlCollection.FlowSeq) {
                        found = true;
                    } else {
                        found = this.exitTo(NodeType.MAP);
                        currentNode = this.getCurrentNode();
                    }
                    MapEntry entryNode = new MapEntry(!found ? 0x444200 : 0, currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode(entryNode);
                    this.attachProblem((DslAstNode)entryNode, token);
                    if (token.getLength() <= 0) continue block42;
                    entryNode.keyIndicatorOffset = entryNode.getStartOffset();
                    continue block42;
                }
                case Value: {
                    boolean found;
                    MapEntry entryNode;
                    this.ensureRecordContent(token.getStartIndex());
                    DslAstNode currentNode = this.getCurrentNode();
                    if (currentNode instanceof YamlCollection.FlowSeq) {
                        found = true;
                    } else {
                        found = this.exitTo(NodeType.KEY_VALUE_ENTRY, NodeType.MAP);
                        currentNode = this.getCurrentNode();
                    }
                    if (currentNode.getNodeType() == NodeType.KEY_VALUE_ENTRY) {
                        entryNode = (MapEntry)currentNode;
                        entryNode.setEndOffset(token.getEndIndex());
                    } else {
                        entryNode = new MapEntry(!found ? 4477440 : 0, currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode(entryNode);
                    }
                    this.attachProblem((DslAstNode)entryNode, token);
                    if (token.getLength() <= 0) continue block42;
                    entryNode.valueIndicatorOffset = token.getStartIndex();
                    continue block42;
                }
                case Scalar: {
                    ScalarToken scalarToken = (ScalarToken)token;
                    DslAstNode currentNode = this.checkParent(token);
                    Object node = switch (scalarToken.getStyle()) {
                        case ScalarStyle.DOUBLE_QUOTED -> new YamlScalar.DQuoted(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                        case ScalarStyle.SINGLE_QUOTED -> new YamlScalar.SQuoated(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                        case ScalarStyle.LITERAL -> new YamlScalar.Literal(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                        case ScalarStyle.FOLDED -> new YamlScalar.Folded(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                        default -> new YamlScalar.Plain(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                    };
                    this.addChildTerm((DslAstNode)node);
                    this.attachProblem((DslAstNode)node, token);
                    continue block42;
                }
            }
        }
    }

    private void attachProblem(DslAstNode node, Token token) {
        if ((node.getStatusCode() & 0x400000) != 0) {
            return;
        }
        SyntaxProblem problem = token.getProblem();
        if (problem != null) {
            this.setStatus(node, problem.getStatusCode(), problem.getStatusDetail());
        }
    }
}

