/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core;

import java.util.List;
import org.eclipse.statet.internal.rhelp.core.RHelpSearchIndexQueryIntern;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSearchQuery;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public class RHelpSearchQuery
extends RHelpSearchIndexQueryIntern {
    public static final int TOPIC_SEARCH = 1;
    public static final int FIELD_SEARCH = 2;
    public static final int DOC_SEARCH = 3;
    public static final String TOPICS_FIELD = "alias.txt";
    public static final String TITLE_FIELD = "title.txt";
    public static final String CONCEPTS_FIELD = "concept.txt";
    private final int searchType;
    private final String searchText;
    private final ImList<String> fields;
    private final ImList<String> keywords;
    private final ImList<String> packages;
    private final @Nullable REnv rEnv;

    public RHelpSearchQuery(int type, String text, List<String> fields, List<String> keywords, List<String> packages, @Nullable REnv rEnv) {
        this.searchType = type;
        this.searchText = text;
        this.fields = ImCollections.toList(fields);
        this.keywords = ImCollections.toList(keywords);
        this.packages = ImCollections.toList(packages);
        this.rEnv = rEnv != null ? rEnv.resolve() : null;
    }

    public REnv getREnv() {
        return (REnv)ObjectUtils.nonNullAssert((Object)this.rEnv);
    }

    public int getSearchType() {
        return this.searchType;
    }

    public String getSearchString() {
        return this.searchText;
    }

    public ImList<String> getEnabledFields() {
        return this.fields;
    }

    public ImList<String> getKeywords() {
        return this.keywords;
    }

    public ImList<String> getPackages() {
        return this.packages;
    }

    public void validate() throws StatusException {
        REnv rEnv = this.rEnv;
        if (rEnv == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "The R environment is missing."));
        }
        if (rEnv.isDeleted()) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "The R environment no longer exists."));
        }
        if (rEnv.get(REnvHelpConfiguration.class) == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "The R environment not supported."));
        }
        if (!this.isIndexQueryOk()) {
            this.setIndexQuery(REnvIndexSearchQuery.compile(this));
        }
    }

    public String toString() {
        return this.searchText;
    }
}

