/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.CallArg;
import org.eclipse.statet.r.core.source.ast.CallArgs;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.RParser;

@NonNullByDefault
public final class FCall
extends RAstNode {
    final Expression refExpr = new Expression();
    int argsOpenOffset = Integer.MIN_VALUE;
    final Args args = new Args(this);
    int argsCloseOffset = Integer.MIN_VALUE;

    FCall() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.F_CALL;
    }

    @Override
    public final @Nullable RTerminal getOperator(int index) {
        return null;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        return switch (index) {
            case 0 -> this.refExpr.node;
            case 1 -> this.args;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.refExpr.node == child) {
            return 0;
        }
        if (this.args == child) {
            return 1;
        }
        return -1;
    }

    public final RAstNode getRefChild() {
        return this.refExpr.node;
    }

    public final int getArgsOpenOffset() {
        return this.argsOpenOffset;
    }

    public final Args getArgsChild() {
        return this.args;
    }

    public final int getArgsCloseOffset() {
        return this.argsCloseOffset;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.refExpr.node.acceptInR(visitor);
        this.args.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.refExpr.node);
        visitor.visit((AstNode)this.args);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.refExpr.node == child) {
            return this.refExpr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.refExpr;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (NodeType.F_CALL == element.getNodeType()) {
            return this.refExpr.node.equalsSingle(((FCall)element).refExpr.node);
        }
        return false;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (expr == this.refExpr) {
            return 4195089;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        if (this.argsCloseOffset != Integer.MIN_VALUE) {
            this.doSetStartEndOffset(this.refExpr.node.getStartOffset(), this.argsCloseOffset + 1);
        } else {
            this.doSetStartEndOffset(this.refExpr.node.getStartOffset(), this.args.getEndOffset());
        }
    }

    public static final class Arg
    extends CallArg {
        Arg(Args parent, int startOffset, int endOffset) {
            super(parent);
            this.doSetStartEndOffset(startOffset, endOffset);
        }

        Arg(Args parent) {
            super(parent);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.F_CALL_ARG;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public @Nullable Args getRParent() {
            return (Args)this.rParent;
        }

        public @Nullable FCall getFCall() {
            return this.rParent != null ? ((Args)this.rParent).getRParent() : null;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.F_CALL_ARG == element.getNodeType();
        }
    }

    public static final class Args
    extends CallArgs {
        private ImList<Arg> args;
        private ImIntList sepOffsets;

        Args(FCall parent) {
            super(parent);
        }

        void finish(RParser.ArgsBuilder<Arg> argsBuilder) {
            this.args = ImCollections.toList(argsBuilder.args);
            this.sepOffsets = ImCollections.toIntList((IntList)argsBuilder.sepOffsets);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.F_CALL_ARGS;
        }

        @Override
        public ImIntList getSeparatorOffsets() {
            return this.sepOffsets;
        }

        @Override
        public final FCall getRParent() {
            return (FCall)this.rParent;
        }

        @Override
        public final boolean hasChildren() {
            return !this.args.isEmpty();
        }

        @Override
        public final int getChildCount() {
            return this.args.size();
        }

        @Override
        public final Arg getChild(int index) {
            return (Arg)((Object)this.args.get(index));
        }

        @Override
        public final int getChildIndex(AstNode child) {
            int i = this.args.size() - 1;
            while (i >= 0) {
                if (this.args.get(i) == child) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        public ImList<? extends Arg> getArgChildren() {
            return this.args;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            for (RAstNode arg : this.args) {
                arg.acceptInR(visitor);
            }
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            for (RAstNode child : this.args) {
                visitor.visit((AstNode)child);
            }
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.F_CALL_ARGS == element.getNodeType();
        }
    }
}

