/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.templates.IWorkbenchTemplateContext;
import org.eclipse.statet.ltk.ui.templates.SourceEditorContextType;

@NonNullByDefault
public class CodeGenerationTemplateContext
extends TemplateContext
implements IWorkbenchTemplateContext {
    private final String lineDelimiter;
    private @Nullable SourceUnit sourceUnit;

    public CodeGenerationTemplateContext(TemplateContextType contextType, String lineDelim) {
        super(contextType);
        this.lineDelimiter = lineDelim;
    }

    public CodeGenerationTemplateContext(TemplateContextType contextType, SourceUnit sourceUnit, String lineDelim) {
        this(contextType, lineDelim);
        this.sourceUnit = sourceUnit;
    }

    @Override
    public @Nullable SourceEditor1 getEditor() {
        return null;
    }

    @Override
    public @Nullable SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public @Nullable String evaluateInfo(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer buffer = this.evaluate(template);
        if (buffer != null) {
            buffer.getString();
        }
        return null;
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public @Nullable TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        Iterator iterator = this.getContextType().resolvers();
        while (iterator.hasNext()) {
            TemplateVariableResolver var = (TemplateVariableResolver)iterator.next();
            if (!(var instanceof SourceEditorContextType.CodeTemplatesVariableResolver)) continue;
            Assert.isNotNull((Object)this.getVariable(var.getType()), (String)("Variable " + var.getType() + "not defined"));
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        String pattern = CodeGenerationTemplateContext.changeLineDelimiter(template.getPattern(), this.lineDelimiter);
        TemplateBuffer buffer = translator.translate(pattern);
        if (buffer == null) {
            return null;
        }
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private static String changeLineDelimiter(String code, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nLines) {
                if (i != 0) {
                    buf.append(lineDelim);
                }
                IRegion region = tracker.getLineInformation(i);
                String line = code.substring(region.getOffset(), region.getOffset() + region.getLength());
                buf.append(line);
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException e) {
            return code;
        }
    }
}

