/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.jface.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class ImageDescriptorRegistry {
    private final Map<ImageDescriptor, Image> registry = new HashMap<ImageDescriptor, Image>();
    private final Display display;
    private boolean disposed;

    public ImageDescriptorRegistry(Display display) {
        this.display = (Display)ObjectUtils.nonNullAssert((Object)display);
        this.display.asyncExec(() -> this.display.disposeExec(this::dispose));
    }

    public ImageDescriptorRegistry() {
        this(UIAccess.getDisplay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Map<ImageDescriptor, Image> map = this.registry;
        synchronized (map) {
            this.disposed = true;
            try {
                for (Image image : this.registry.values()) {
                    image.dispose();
                }
            }
            finally {
                this.registry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Image get(ImageDescriptor descriptor) {
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Map<ImageDescriptor, Image> map = this.registry;
        synchronized (map) {
            Image image = this.registry.get(descriptor);
            if (image == null && !this.disposed && (image = descriptor.createImage(true)) != null) {
                this.registry.put(descriptor, image);
            }
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getRequired(ImageDescriptor descriptor) {
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Map<ImageDescriptor, Image> map = this.registry;
        synchronized (map) {
            Image image = this.registry.get(descriptor);
            if (image == null && !this.disposed) {
                image = descriptor.createImage(true);
                if (image != null) {
                    this.registry.put(descriptor, image);
                } else {
                    throw new RuntimeException("image creation failed");
                }
            }
            return image;
        }
    }
}

