/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.graphic.core.ColorRefDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

@NonNullByDefault
public class ColorPalette
extends Canvas
implements IObjValueWidget<ColorDef> {
    private static final LineAttributes SELECTION1 = new LineAttributes(1.0f, 1, 1, 6, new float[]{1.0f, 1.0f}, 0.0f, 10.0f);
    private static final LineAttributes SELECTION2 = new LineAttributes(1.0f, 1, 1, 6, new float[]{1.0f, 1.0f}, 1.0f, 10.0f);
    private final int size;
    private boolean hasFocus;
    private List<? extends ColorDef> colors = Collections.emptyList();
    private int selectionIdx = -1;
    private int cursorIdx = 0;
    private int columnCount;
    private int visibleRowCount;
    private final CopyOnWriteIdentityListSet<IObjValueListener<@Nullable ColorDef>> valueListeners = new CopyOnWriteIdentityListSet();
    private final Color backgroundColor;

    public ColorPalette(Composite parent, Color backgroundColor) {
        super(parent, 512);
        this.backgroundColor = backgroundColor;
        ScrollBar bar = this.getScrollBar();
        this.size = 8 + LayoutUtils.defaultHSpacing() * 2;
        bar.setVisible(true);
        SWTListener listener = new SWTListener();
        this.addPaintListener(listener);
        this.addListener(11, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        bar.addListener(13, (Listener)listener);
        this.addListener(37, listener);
        this.addListener(8, listener);
        this.addListener(3, listener);
        this.addListener(32, listener);
        this.addListener(1, listener);
        this.addListener(31, listener);
        this.updateScroll();
    }

    public void setColors(List<? extends ColorDef> colors) {
        this.colors = colors;
        this.updateScroll();
        this.checkCursor();
    }

    protected final ScrollBar getScrollBar() {
        return this.getVerticalBar();
    }

    private void checkCursor() {
        if (this.colors.isEmpty()) {
            this.cursorIdx = -1;
            return;
        }
        ScrollBar bar = this.getScrollBar();
        if (this.cursorIdx < 0) {
            this.cursorIdx = bar.getSelection() * this.columnCount;
        }
        if (this.cursorIdx >= this.colors.size()) {
            this.cursorIdx = this.colors.size() - 1;
        }
        if (this.columnCount == 0) {
            return;
        }
        int row = this.cursorIdx / this.columnCount;
        int topRow = bar.getSelection();
        if (row < topRow) {
            bar.setSelection(row);
        } else if (row >= topRow + this.visibleRowCount) {
            bar.setSelection(row - this.visibleRowCount + 1);
        }
    }

    private void updateScroll() {
        ScrollBar bar = this.getScrollBar();
        int count = this.colors.size();
        Rectangle clientArea = this.getClientArea();
        this.columnCount = (clientArea.width - 1) / this.size;
        if (count == 0 || this.columnCount == 0) {
            bar.setEnabled(false);
            bar.setValues(0, 0, 1, 1, 1, 1);
            return;
        }
        int rows = (count + this.columnCount - 1) / this.columnCount;
        this.visibleRowCount = (clientArea.height - 1) / this.size;
        if (rows <= this.visibleRowCount) {
            bar.setEnabled(false);
            bar.setValues(0, 0, 1, 1, 1, 1);
            return;
        }
        bar.setEnabled(true);
        bar.setValues(0, 0, rows, this.visibleRowCount, 1, this.visibleRowCount);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint >= 0 ? wHint : 1 + this.size * 10;
        int height = hHint >= 0 ? hHint : 1 + this.size * 9;
        Rectangle trimmed = this.computeTrim(0, 0, width, height);
        return new Point(trimmed.width, trimmed.height);
    }

    public boolean setFocus() {
        return this.forceFocus();
    }

    public int getColorIdx(int x, int y) {
        int count = this.colors.size();
        if (count == 0 || this.columnCount == 0) {
            return -1;
        }
        ScrollBar bar = this.getScrollBar();
        int idx = (bar.getSelection() + (y - 1) / this.size) * this.columnCount;
        return (idx += (x - 1) / this.size) < count ? idx : -1;
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public Class<@Nullable ColorDef> getValueType() {
        return ColorDef.class;
    }

    @Override
    public void addValueListener(IObjValueListener<@Nullable ColorDef> listener) {
        this.valueListeners.add((Object)((IObjValueListener)ObjectUtils.nonNullAssert(listener)));
    }

    @Override
    public void removeValueListener(IObjValueListener<@Nullable ColorDef> listener) {
        this.valueListeners.remove(listener);
    }

    private boolean doSetColor(int idx, int time, int flags) {
        ColorDef newValue;
        ColorDef oldValue = this.selectionIdx >= 0 ? this.colors.get(this.selectionIdx) : null;
        ColorDef colorDef = newValue = idx >= 0 ? this.colors.get(idx) : null;
        if (oldValue == newValue && flags == 0) {
            return false;
        }
        this.selectionIdx = idx;
        ObjValueEvent<ColorDef> event = new ObjValueEvent<ColorDef>(this, time, 0, oldValue, newValue, flags);
        for (IObjValueListener listener : this.valueListeners) {
            event.newValue = newValue;
            listener.valueChanged(event);
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    @Override
    public @Nullable ColorDef getValue(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        return this.selectionIdx >= 0 ? this.colors.get(this.selectionIdx) : null;
    }

    @Override
    public void setValue(int idx, @Nullable ColorDef value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        if (value != null) {
            ColorDef c;
            int i = 0;
            while (i < this.colors.size()) {
                c = this.colors.get(i);
                if (c.equals((Object)value)) {
                    this.setValue(i);
                    return;
                }
                ++i;
            }
            if (value instanceof ColorRefDef) {
                ColorDef ref = ((ColorRefDef)value).getRef();
                int i2 = 0;
                while (i2 < this.colors.size()) {
                    ColorDef c2 = this.colors.get(i2);
                    if (c2.equals((Object)ref)) {
                        this.setValue(i2);
                        return;
                    }
                    ++i2;
                }
            }
            i = 0;
            while (i < this.colors.size()) {
                c = this.colors.get(i);
                if (c.equalsRGB(value)) {
                    this.setValue(i);
                    return;
                }
                ++i;
            }
        }
        this.setValue(-1);
    }

    public void setValue(int idx) {
        this.cursorIdx = idx;
        this.checkCursor();
        if (this.selectionIdx != idx && this.doSetColor(idx, 0, 0)) {
            return;
        }
        this.redraw();
    }

    public void setCursor(int idx, ColorDef value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        int colorIdx = -1;
        int i = 0;
        while (i < this.colors.size()) {
            ColorDef c = this.colors.get(i);
            if (c.equals((Object)value)) {
                colorIdx = i;
                break;
            }
            if (colorIdx == -1 && c.equalsRGB(value)) {
                colorIdx = i;
            }
            ++i;
        }
        if (colorIdx >= 0) {
            this.cursorIdx = colorIdx;
            this.checkCursor();
            this.redraw();
        }
    }

    private class SWTListener
    implements Listener,
    PaintListener {
        private boolean doubleClick;

        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    ColorPalette.this.updateScroll();
                    ColorPalette.this.checkCursor();
                    return;
                }
                case 15: {
                    ColorPalette.this.hasFocus = true;
                    ColorPalette.this.redraw();
                    return;
                }
                case 16: {
                    ColorPalette.this.hasFocus = false;
                    ColorPalette.this.redraw();
                    return;
                }
                case 13: {
                    ColorPalette.this.redraw();
                    return;
                }
                case 32: {
                    int idx = ColorPalette.this.getColorIdx(event.x, event.y);
                    if (idx >= 0) {
                        ColorPalette.this.setToolTipText(ColorPalette.this.colors.get(idx).toString());
                    } else {
                        ColorPalette.this.setToolTipText("");
                    }
                    return;
                }
                case 3: {
                    this.doubleClick = false;
                    int idx = ColorPalette.this.getColorIdx(event.x, event.y);
                    if (idx >= 0) {
                        ColorPalette.this.cursorIdx = idx;
                        if (!ColorPalette.this.doSetColor(idx, event.time, 0)) {
                            this.doubleClick = true;
                            ColorPalette.this.redraw();
                        }
                    }
                    return;
                }
                case 8: {
                    if (this.doubleClick) {
                        this.doubleClick = false;
                        int idx = ColorPalette.this.getColorIdx(event.x, event.y);
                        if (idx >= 0 && idx == ColorPalette.this.selectionIdx) {
                            ColorPalette.this.cursorIdx = idx;
                            if (!ColorPalette.this.doSetColor(idx, event.time, 1)) {
                                ColorPalette.this.redraw();
                            }
                        }
                    }
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000003: {
                            if (event.stateMask == 0) {
                                --ColorPalette.this.cursorIdx;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 0x1000004: {
                            if (event.stateMask == 0) {
                                ++ColorPalette.this.cursorIdx;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 0x1000001: {
                            if (event.stateMask == 0 && ColorPalette.this.cursorIdx >= ColorPalette.this.columnCount) {
                                ColorPalette.this.cursorIdx -= ColorPalette.this.columnCount;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 0x1000002: {
                            if (event.stateMask == 0 && ColorPalette.this.cursorIdx < ColorPalette.this.colors.size() - ColorPalette.this.columnCount) {
                                ColorPalette.this.cursorIdx += ColorPalette.this.columnCount;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 13: {
                            ColorPalette.this.doSetColor(ColorPalette.this.cursorIdx, event.time, 1);
                            return;
                        }
                        case 32: {
                            ColorPalette.this.doSetColor(ColorPalette.this.cursorIdx, event.time, 0);
                            return;
                        }
                    }
                    return;
                }
                case 31: {
                    switch (event.detail) {
                        case 4: 
                        case 32: 
                        case 64: 
                        case 256: 
                        case 512: {
                            event.doit = false;
                            return;
                        }
                    }
                    event.doit = true;
                }
            }
        }

        public void paintControl(PaintEvent e) {
            int count = ColorPalette.this.colors.size();
            if (count == 0 || ColorPalette.this.columnCount == 0) {
                return;
            }
            ScrollBar bar = ColorPalette.this.getScrollBar();
            Rectangle clientArea = ColorPalette.this.getClientArea();
            int idx = bar.getSelection() * ColorPalette.this.columnCount;
            GC gc = e.gc;
            Display display = ColorPalette.this.getDisplay();
            int column = 0;
            int x = 1;
            int y = 1;
            while (idx < count) {
                ColorDef colorDef = ColorPalette.this.colors.get(idx);
                gc.setBackground(new Color(colorDef.getRed(), colorDef.getGreen(), colorDef.getBlue()));
                gc.fillRectangle(x, y, ColorPalette.this.size - 1, ColorPalette.this.size - 1);
                if (idx == ColorPalette.this.selectionIdx) {
                    gc.setLineStyle(1);
                    gc.setForeground(display.getSystemColor(2));
                    gc.drawRectangle(x - 1, y - 1, ColorPalette.this.size, ColorPalette.this.size);
                    gc.setForeground(ColorPalette.this.getBackground());
                    gc.drawRectangle(x, y, ColorPalette.this.size - 2, ColorPalette.this.size - 2);
                } else if (idx == count - 1 && Math.abs(colorDef.getRed() - ColorPalette.this.backgroundColor.getRed()) < 8 && Math.abs(colorDef.getGreen() - ColorPalette.this.backgroundColor.getGreen()) < 8 && Math.abs(colorDef.getBlue() - ColorPalette.this.backgroundColor.getBlue()) < 8) {
                    gc.setLineStyle(1);
                    gc.setForeground(display.getSystemColor(16));
                    gc.drawRectangle(x - 1, y - 1, ColorPalette.this.size, ColorPalette.this.size);
                    gc.setForeground(ColorPalette.this.getBackground());
                    gc.drawRectangle(x, y, ColorPalette.this.size - 2, ColorPalette.this.size - 2);
                }
                if (idx == ColorPalette.this.cursorIdx && ColorPalette.this.hasFocus) {
                    gc.setLineAttributes(SELECTION1);
                    gc.setForeground(display.getSystemColor(2));
                    gc.drawRectangle(x, y, ColorPalette.this.size - 2, ColorPalette.this.size - 2);
                    gc.setLineAttributes(SELECTION2);
                    gc.setForeground(display.getSystemColor(1));
                    gc.drawRectangle(x, y, ColorPalette.this.size - 2, ColorPalette.this.size - 2);
                }
                ++idx;
                if (++column < ColorPalette.this.columnCount) {
                    x += ColorPalette.this.size;
                    continue;
                }
                column = 0;
                x = 0;
                if ((y += ColorPalette.this.size) > clientArea.height) break;
            }
        }
    }
}

