/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.io.internal.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class WorkspaceUtilImpl
extends FileUtil {
    private static final InputStream EMPTY_INPUT = new ByteArrayInputStream(new byte[0]);
    private static final String LABEL_2_WORKSPACE = "' (" + Messages.FileType_Workspace_name + ")";
    private final IFile file;

    public WorkspaceUtilImpl(IFile file) {
        this.file = file;
    }

    @Override
    public String getLabel() {
        return "'" + this.file.getFullPath().makeAbsolute().toString() + LABEL_2_WORKSPACE;
    }

    @Override
    public @Nullable URI getURI() {
        return this.file.getLocationURI();
    }

    @Override
    public long getTimeStamp(IProgressMonitor monitor) throws CoreException {
        long stamp = this.file.getLocalTimeStamp();
        return stamp;
    }

    @Override
    public FileUtil.ReadTextFileOperation createReadTextFileOp(final FileUtil.ReaderAction action) {
        return new FileUtil.ReadTextFileOperation(this){

            @Override
            protected FileUtil.FileInput getInput(IProgressMonitor monitor) throws CoreException, IOException {
                try {
                    InputStream raw = WorkspaceUtilImpl.this.file.getContents(true);
                    Charset charset = Charset.forName(WorkspaceUtilImpl.this.file.getCharset(true));
                    FileUtil.FileInput fileInput = new FileUtil.FileInput(raw, charset);
                    return fileInput;
                }
                finally {
                    monitor.done();
                }
            }

            @Override
            protected FileUtil.ReaderAction getAction() {
                return action;
            }

            @Override
            public void doOperation(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                this.runAsWorkspaceRunnable(monitor, null);
            }
        };
    }

    @Override
    public FileUtil.WriteTextFileOperation createWriteTextFileOp(final String content) {
        return new FileUtil.WriteTextFileOperation(this){

            @Override
            public void doOperation(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                ISchedulingRule rule = WorkspaceUtilImpl.this.file.exists() ? WorkspaceUtilImpl.this.file.getWorkspace().getRuleFactory().modifyRule((IResource)WorkspaceUtilImpl.this.file) : WorkspaceUtilImpl.this.file.getWorkspace().getRuleFactory().createRule((IResource)WorkspaceUtilImpl.this.file);
                this.runAsWorkspaceRunnable(monitor, rule);
            }

            @Override
            protected void writeImpl(SubMonitor m) throws CoreException, UnsupportedEncodingException {
                boolean exists = WorkspaceUtilImpl.this.file.exists();
                if (exists && (this.mode & 1) != 0) {
                    if (this.forceCharset) {
                        WorkspaceUtilImpl.this.file.setCharset(this.charset.name(), (IProgressMonitor)m.newChild(20));
                    } else {
                        this.charset = Charset.forName(WorkspaceUtilImpl.this.file.getCharset(true));
                        m.worked(20);
                    }
                    WorkspaceUtilImpl.this.file.appendContents((InputStream)new ByteArrayInputStream(content.getBytes(this.charset)), 3, (IProgressMonitor)m.newChild(80));
                } else {
                    if (exists && (this.mode & 2) != 0) {
                        WorkspaceUtilImpl.this.file.setContents(EMPTY_INPUT, 3, (IProgressMonitor)m.newChild(15));
                    } else {
                        WorkspaceUtilImpl.this.file.create(EMPTY_INPUT, 1, (IProgressMonitor)m.newChild(15));
                    }
                    if (this.forceCharset || !this.charset.equals(Charset.forName(WorkspaceUtilImpl.this.file.getCharset(true)))) {
                        WorkspaceUtilImpl.this.file.setCharset(this.charset.name(), (IProgressMonitor)m.newChild(5));
                    } else {
                        m.worked(5);
                    }
                    WorkspaceUtilImpl.this.file.setContents((InputStream)new ByteArrayInputStream(content.getBytes(this.charset)), 0, (IProgressMonitor)m.newChild(80));
                }
            }
        };
    }
}

