/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.internal.operation.MoveViewOperation;
import org.eclipse.sirius.diagram.ui.business.internal.operation.ShiftDirectBorderedNodesOperation;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.ChangeBendpointsOfEdgesCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class ChildrenAdjustmentCommand
extends AbstractTransactionalCommand {
    CompositeTransactionalCommand wrappedCommand;
    IGraphicalEditPart host;
    ChangeBoundsRequest request;
    private boolean adjustBorderNodes;
    private boolean adjustSubNodes;

    public ChildrenAdjustmentCommand(IGraphicalEditPart host, ChangeBoundsRequest request) {
        this(host, request, true, true);
    }

    public ChildrenAdjustmentCommand(IGraphicalEditPart host, ChangeBoundsRequest request, boolean borderNodes, boolean subNodes) {
        super(host.getEditingDomain(), Messages.ChildrenAdjustmentCommand_label, null);
        this.host = host;
        this.request = request;
        this.adjustBorderNodes = borderNodes;
        this.adjustSubNodes = subNodes;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
        CommandResult result = CommandResult.newOKCommandResult();
        this.wrappedCommand = new CompositeTransactionalCommand(this.host.getEditingDomain(), this.getLabel());
        RequestQuery rq = new RequestQuery((Request)this.request);
        boolean keepSameAbsoluteLocation = false;
        if (rq.isResizeFromTop() || rq.isResizeFromLeft() || this.request.isCenteredResize()) {
            Object childrenMoveModeExtendedData = this.request.getExtendedData().get("keepSameAbsoluteLocation");
            boolean bl = keepSameAbsoluteLocation = childrenMoveModeExtendedData == null || childrenMoveModeExtendedData != null && (Boolean)childrenMoveModeExtendedData != false;
            if (keepSameAbsoluteLocation && this.adjustSubNodes) {
                this.addChildrenAdjustmentCommands(this.host, this.wrappedCommand, this.request);
            } else {
                this.addChildrenEdgesAdjustmentCommands(this.host, this.wrappedCommand, this.request);
            }
        }
        if (this.host instanceof IBorderedShapeEditPart && this.adjustBorderNodes) {
            this.addBorderChildrenAdjustmentCommands(this.host, this.wrappedCommand, this.request, keepSameAbsoluteLocation);
        }
        if (this.wrappedCommand.size() > 0) {
            if (this.wrappedCommand.canExecute()) {
                try {
                    this.wrappedCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    result = CommandResult.newErrorCommandResult((Throwable)e);
                }
            } else {
                result = CommandResult.newWarningCommandResult((String)Messages.ChildrenAdjustmentCommand_errorMsg, null);
            }
        }
        return result;
    }

    public boolean canUndo() {
        if (this.wrappedCommand != null && this.wrappedCommand.size() > 0) {
            return this.wrappedCommand.canUndo();
        }
        return true;
    }

    public boolean canRedo() {
        if (this.wrappedCommand != null && this.wrappedCommand.size() > 0) {
            return this.wrappedCommand.canRedo();
        }
        return true;
    }

    public void dispose() {
        this.host = null;
        this.request = null;
        this.wrappedCommand = null;
    }

    private void addChildrenAdjustmentCommands(IGraphicalEditPart resizedPart, CompositeTransactionalCommand cc, ChangeBoundsRequest cbr) {
        PrecisionPoint delta = new PrecisionPoint(cbr.getMoveDelta().getNegated());
        GraphicalHelper.applyInverseZoomOnPoint((IGraphicalEditPart)resizedPart, (Point)delta);
        AbstractDNodeContainerCompartmentEditPart compartment = (AbstractDNodeContainerCompartmentEditPart)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resizedPart.getChildren(), AbstractDNodeContainerCompartmentEditPart.class), null);
        if (compartment != null) {
            Iterable childrenExceptBorderItemPart = Iterables.filter((Iterable)compartment.getChildren(), EditPart.class);
            for (EditPart editPart : childrenExceptBorderItemPart) {
                EObjectAdapter adapter = new EObjectAdapter((EObject)((Node)editPart.getModel()));
                cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new MoveViewOperation(DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)adapter, (Point)delta)));
            }
        }
    }

    private void addChildrenEdgesAdjustmentCommands(IGraphicalEditPart resizedPart, CompositeTransactionalCommand cc, ChangeBoundsRequest cbr) {
        PrecisionPoint delta = new PrecisionPoint(cbr.getMoveDelta());
        GraphicalHelper.applyInverseZoomOnPoint((IGraphicalEditPart)resizedPart, (Point)delta);
        DNodeContainerViewNodeContainerCompartmentEditPart compartment = (DNodeContainerViewNodeContainerCompartmentEditPart)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resizedPart.getChildren(), DNodeContainerViewNodeContainerCompartmentEditPart.class), null);
        if (compartment != null) {
            Iterable childrenExceptBorderItemPart = Iterables.filter((Iterable)compartment.getChildren(), EditPart.class);
            for (EditPart editPart : childrenExceptBorderItemPart) {
                if (!(editPart instanceof IGraphicalEditPart)) continue;
                cc.compose((IUndoableOperation)new ChangeBendpointsOfEdgesCommand((IGraphicalEditPart)editPart, delta));
            }
        }
    }

    private void addBorderChildrenAdjustmentCommands(IGraphicalEditPart resizedPart, CompositeTransactionalCommand cc, ChangeBoundsRequest cbr, boolean keepSameAbsoluteLocation) {
        List<Node> borderNodes;
        PrecisionPoint delta;
        List<IBorderItemEditPart> childrenWithEdgesToMove;
        Map<Node, Dimension> childrenToMoveWithDelta;
        List<Node> childrenToMove;
        RequestQuery rq = new RequestQuery((Request)cbr);
        Rectangle logicalDelta = rq.getLogicalDelta();
        EditPartQuery resizedPartQuery = new EditPartQuery(resizedPart);
        if (rq.isResizeFromTop() || rq.isResizeFromBottom()) {
            int verticalSizeDelta = logicalDelta.height;
            childrenToMove = resizedPartQuery.getBorderedNodes(4);
            if (!childrenToMove.isEmpty()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new ShiftDirectBorderedNodesOperation(childrenToMove, new Dimension(0, verticalSizeDelta))));
            }
            if (rq.isResizeFromTop()) {
                childrenToMoveWithDelta = resizedPartQuery.getBorderedNodesToMoveWithDelta(16, 1, verticalSizeDelta);
                childrenToMoveWithDelta.putAll(resizedPartQuery.getBorderedNodesToMoveWithDelta(8, 1, verticalSizeDelta));
            } else {
                childrenToMoveWithDelta = resizedPartQuery.getBorderedNodesToMoveWithDelta(16, 4, verticalSizeDelta);
                childrenToMoveWithDelta.putAll(resizedPartQuery.getBorderedNodesToMoveWithDelta(8, 4, verticalSizeDelta));
            }
            for (Map.Entry<Node, Dimension> entry : childrenToMoveWithDelta.entrySet()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{entry.getKey()}), entry.getValue())));
            }
            if (rq.isResizeFromTop() || cbr.isCenteredResize()) {
                childrenWithEdgesToMove = resizedPartQuery.getBorderNodeEditParts(1);
                delta = cbr.isCenteredResize() ? new PrecisionPoint(0, -verticalSizeDelta - logicalDelta.y) : new PrecisionPoint(0, -verticalSizeDelta);
                for (IBorderItemEditPart borderNodeEditPart : childrenWithEdgesToMove) {
                    cc.compose((IUndoableOperation)new ChangeBendpointsOfEdgesCommand((IGraphicalEditPart)borderNodeEditPart, delta));
                }
                if (keepSameAbsoluteLocation) {
                    if (cbr.isCenteredResize()) {
                        verticalSizeDelta += logicalDelta.y;
                    }
                    borderNodes = resizedPartQuery.getBorderedNodes(8);
                    borderNodes.addAll(resizedPartQuery.getBorderedNodes(16));
                    borderNodes.removeAll(childrenToMoveWithDelta.keySet());
                    cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new ShiftDirectBorderedNodesOperation(borderNodes, new Dimension(0, verticalSizeDelta))));
                } else {
                    childrenWithEdgesToMove = new ArrayList<IBorderItemEditPart>();
                    childrenWithEdgesToMove.addAll(resizedPartQuery.getBorderNodeEditParts(8));
                    childrenWithEdgesToMove.addAll(resizedPartQuery.getBorderNodeEditParts(16));
                    childrenWithEdgesToMove.removeAll(childrenToMoveWithDelta.keySet());
                    delta = cbr.isCenteredResize() ? new PrecisionPoint(0, -verticalSizeDelta - logicalDelta.y) : new PrecisionPoint(0, -verticalSizeDelta);
                    for (IBorderItemEditPart borderNodeEditPart : childrenWithEdgesToMove) {
                        cc.compose((IUndoableOperation)new ChangeBendpointsOfEdgesCommand((IGraphicalEditPart)borderNodeEditPart, delta));
                    }
                }
            }
        }
        if (rq.isResizeFromRight() || rq.isResizeFromLeft()) {
            int horizontalSizeDelta = logicalDelta.width;
            childrenToMove = resizedPartQuery.getBorderedNodes(16);
            if (!childrenToMove.isEmpty()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new ShiftDirectBorderedNodesOperation(childrenToMove, new Dimension(horizontalSizeDelta, 0))));
            }
            if (rq.isResizeFromRight()) {
                childrenToMoveWithDelta = resizedPartQuery.getBorderedNodesToMoveWithDelta(1, 16, horizontalSizeDelta);
                childrenToMoveWithDelta.putAll(resizedPartQuery.getBorderedNodesToMoveWithDelta(4, 16, horizontalSizeDelta));
            } else {
                childrenToMoveWithDelta = resizedPartQuery.getBorderedNodesToMoveWithDelta(1, 8, horizontalSizeDelta);
                childrenToMoveWithDelta.putAll(resizedPartQuery.getBorderedNodesToMoveWithDelta(4, 8, horizontalSizeDelta));
            }
            for (Map.Entry<Node, Dimension> entry : childrenToMoveWithDelta.entrySet()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{entry.getKey()}), entry.getValue())));
            }
            if (rq.isResizeFromLeft() || cbr.isCenteredResize()) {
                childrenWithEdgesToMove = resizedPartQuery.getBorderNodeEditParts(8);
                delta = cbr.isCenteredResize() ? new PrecisionPoint(-horizontalSizeDelta - logicalDelta.x, 0) : new PrecisionPoint(-horizontalSizeDelta, 0);
                for (IBorderItemEditPart borderNodeEditPart : childrenWithEdgesToMove) {
                    cc.compose((IUndoableOperation)new ChangeBendpointsOfEdgesCommand((IGraphicalEditPart)borderNodeEditPart, delta));
                }
                if (keepSameAbsoluteLocation) {
                    if (cbr.isCenteredResize()) {
                        horizontalSizeDelta += logicalDelta.x;
                    }
                    borderNodes = resizedPartQuery.getBorderedNodes(1);
                    borderNodes.addAll(resizedPartQuery.getBorderedNodes(4));
                    borderNodes.removeAll(childrenToMoveWithDelta.keySet());
                    cc.compose((IUndoableOperation)CommandFactory.createICommand(cc.getEditingDomain(), new ShiftDirectBorderedNodesOperation(borderNodes, new Dimension(horizontalSizeDelta, 0))));
                } else {
                    childrenWithEdgesToMove = resizedPartQuery.getBorderNodeEditParts(1);
                    childrenWithEdgesToMove.addAll(resizedPartQuery.getBorderNodeEditParts(4));
                    childrenWithEdgesToMove.removeAll(childrenToMoveWithDelta.keySet());
                    delta = cbr.isCenteredResize() ? new PrecisionPoint(-horizontalSizeDelta - logicalDelta.x, 0) : new PrecisionPoint(-horizontalSizeDelta, 0);
                    for (IBorderItemEditPart borderNodeEditPart : childrenWithEdgesToMove) {
                        cc.compose((IUndoableOperation)new ChangeBendpointsOfEdgesCommand((IGraphicalEditPart)borderNodeEditPart, delta));
                    }
                }
            }
        }
    }
}

