/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.rotation;

import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.intermediate.rotation.IRadialRotator;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;

public class AngleRotation
implements IRadialRotator {
    @Override
    public void rotate(ElkNode graph) {
        double targetAngle = (Double)graph.getProperty(RadialOptions.ROTATION_TARGET_ANGLE);
        if (((Boolean)graph.getProperty(RadialOptions.ROTATION_COMPUTE_ADDITIONAL_WEDGE_SPACE)).booleanValue()) {
            double alignmentAngle;
            double wedgeAngle;
            ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
            ElkNode lastNode = (ElkNode)((ElkEdge)root.getOutgoingEdges().get(root.getOutgoingEdges().size() - 1)).getTargets().get(0);
            ElkNode firstNode = (ElkNode)((ElkEdge)root.getOutgoingEdges().get(0)).getTargets().get(0);
            KVector lastVector = new KVector(lastNode.getX() + lastNode.getWidth() / 2.0, lastNode.getY() + lastNode.getHeight() / 2.0);
            KVector firstVector = new KVector(firstNode.getX() + firstNode.getWidth() / 2.0, firstNode.getY() + firstNode.getHeight() / 2.0);
            double alpha = targetAngle;
            if (alpha <= 0.0) {
                alpha += Math.PI * 2;
            }
            if ((wedgeAngle = lastVector.angle(firstVector)) <= 0.0) {
                wedgeAngle += Math.PI * 2;
            }
            if ((alignmentAngle = Math.atan2(lastVector.y, lastVector.x)) <= 0.0) {
                alignmentAngle += Math.PI * 2;
            }
            targetAngle = Math.PI - (alignmentAngle - alpha + wedgeAngle / 2.0);
        }
        for (ElkNode node : graph.getChildren()) {
            KVector pos = new KVector(node.getX() + node.getWidth() / 2.0, node.getY() + node.getHeight() / 2.0);
            pos.rotate(targetAngle);
            node.setLocation(pos.x - node.getWidth() / 2.0, pos.y - node.getHeight() / 2.0);
        }
    }
}

