/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.ColumnPrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.CompositeEntry;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.CompositePiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class ColumnIterator
implements PrintIterator {
    private PrintIterator target;
    private final int columns;
    private final int spacing;
    private final boolean compressed;

    ColumnIterator(ColumnPrint print, Device device, GC gc) {
        this.target = print.target.iterator(device, gc);
        this.columns = print.columns;
        this.spacing = Math.round((float)(print.spacing * device.getDPI().x) / 72.0f);
        this.compressed = print.compressed;
    }

    ColumnIterator(ColumnIterator that) {
        this.target = that.target.copy();
        this.columns = that.columns;
        this.spacing = that.spacing;
        this.compressed = that.compressed;
    }

    @Override
    public Point minimumSize() {
        return this.computeSize(this.target.minimumSize());
    }

    @Override
    public Point preferredSize() {
        return this.computeSize(this.target.preferredSize());
    }

    private Point computeSize(Point targetSize) {
        return new Point(targetSize.x * this.columns + this.spacing * (this.columns - 1), targetSize.y);
    }

    @Override
    public boolean hasNext() {
        return this.target.hasNext();
    }

    int[] computeColSizes(int width) {
        int[] colSizes = new int[this.columns];
        int availableWidth = width - this.spacing * (this.columns - 1);
        int i = 0;
        while (i < colSizes.length) {
            colSizes[i] = availableWidth / (this.columns - i);
            availableWidth -= colSizes[i];
            ++i;
        }
        return colSizes;
    }

    Point[] computeColOffsets(int[] colSizes) {
        Point[] colOffsets = new Point[this.columns];
        int xOffset = 0;
        int i = 0;
        while (i < this.columns) {
            colOffsets[i] = new Point(xOffset, 0);
            xOffset += colSizes[i] + this.spacing;
            ++i;
        }
        return colOffsets;
    }

    PrintPiece[] nextColumns(PrintIterator iterator, int[] colSizes, int height) {
        ArrayList<PrintPiece> pieces = new ArrayList<PrintPiece>();
        int i = 0;
        while (i < this.columns && iterator.hasNext()) {
            PrintPiece piece = PaperClips.next(iterator, colSizes[i], height);
            if (piece == null) {
                return this.disposePieces(pieces);
            }
            pieces.add(piece);
            ++i;
        }
        return pieces.toArray(new PrintPiece[pieces.size()]);
    }

    private PrintPiece[] disposePieces(List pieces) {
        for (PrintPiece piece : pieces) {
            piece.dispose();
        }
        return null;
    }

    PrintPiece createResult(PrintPiece[] pieces, int[] colSizes) {
        CompositeEntry[] entries = new CompositeEntry[pieces.length];
        Point[] offsets = this.computeColOffsets(colSizes);
        int i = 0;
        while (i < pieces.length) {
            entries[i] = new CompositeEntry(pieces[i], offsets[i]);
            ++i;
        }
        return new CompositePiece(entries);
    }

    @Override
    public PrintPiece next(int width, int height) {
        int[] colSizes = this.computeColSizes(width);
        PrintIterator iter = this.target.copy();
        PrintPiece[] columns = this.nextColumns(iter, colSizes, height);
        if (columns == null) {
            return null;
        }
        if (!iter.hasNext() && this.compressed) {
            return this.nextCompressed(colSizes, iter, columns);
        }
        this.target = iter;
        return this.createResult(columns, colSizes);
    }

    private PrintPiece nextCompressed(int[] colSizes, PrintIterator iter, PrintPiece[] columns) {
        int highestInvalidHeight = 0;
        int lowestValidHeight = this.getMaxHeight(columns);
        PrintIterator bestIteration = iter;
        PrintPiece[] bestColumns = columns;
        while (lowestValidHeight > highestInvalidHeight + 1) {
            int testHeight = (lowestValidHeight + highestInvalidHeight + 1) / 2;
            iter = this.target.copy();
            columns = this.nextColumns(iter, colSizes, testHeight);
            if (columns == null) {
                highestInvalidHeight = testHeight;
                continue;
            }
            if (iter.hasNext()) {
                highestInvalidHeight = testHeight;
                this.disposePieces(columns);
                continue;
            }
            this.disposePieces(bestColumns);
            bestIteration = iter;
            bestColumns = columns;
            lowestValidHeight = this.getMaxHeight(bestColumns);
        }
        this.target = bestIteration;
        return this.createResult(bestColumns, colSizes);
    }

    private int getMaxHeight(PrintPiece[] pieces) {
        int result = 0;
        int i = 0;
        while (i < pieces.length) {
            result = Math.max(result, pieces[i].getSize().y);
            ++i;
        }
        return result;
    }

    private void disposePieces(PrintPiece[] pieces) {
        int i = 0;
        while (i < pieces.length) {
            pieces[i].dispose();
            ++i;
        }
    }

    @Override
    public PrintIterator copy() {
        return new ColumnIterator(this);
    }
}

