/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import java.util.Objects;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.SequenceLayout;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.sequence.tool.internal.SequenceDiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.ext.base.Option;

public class SynchronizeGraphicalOrderingOperation
extends AbstractModelChangeOperation<Boolean> {
    private final Diagram sequenceDiagram;
    private final boolean pack;

    public SynchronizeGraphicalOrderingOperation(Diagram sequenceDiagram, boolean pack) {
        super(Messages.SynchronizeGraphicalOrderingOperation_operationName);
        this.sequenceDiagram = Objects.requireNonNull(sequenceDiagram);
        this.pack = pack;
    }

    public Boolean execute() {
        boolean result = false;
        Objects.requireNonNull(this.sequenceDiagram);
        SequenceLayout sequenceLayout = new SequenceLayout(this.sequenceDiagram);
        Option<SequenceDiagram> sd = sequenceLayout.getSequenceDiagram();
        try {
            SequenceDDiagram diagram;
            if (sd.some() && (diagram = (SequenceDDiagram)((SequenceDiagram)sd.get()).getNotationDiagram().getElement()) != null && diagram.getGraphicalOrdering().getEventEnds().size() == diagram.getSemanticOrdering().getEventEnds().size()) {
                boolean observationLayout;
                boolean horizontalLayout;
                boolean verticalLayout = sequenceLayout.verticalLayout(this.pack);
                if (verticalLayout) {
                    ((SequenceDiagram)sd.get()).clearOrderedCaches();
                }
                if (horizontalLayout = sequenceLayout.horizontalLayout(this.pack)) {
                    ((SequenceDiagram)sd.get()).clearOrderedCaches();
                }
                if (observationLayout = sequenceLayout.observationLayout(this.pack)) {
                    ((SequenceDiagram)sd.get()).clearOrderedCaches();
                }
                if (verticalLayout || horizontalLayout || observationLayout) {
                    sequenceLayout.flagSequenceEvents();
                    result = true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            SequenceDiagramPlugin.getPlugin().getLog().error(Messages.SequenceDiagram_InternalError, (Throwable)e);
            throw e;
        }
        return result;
    }
}

