/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.spore;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.elk.alg.common.compaction.Scanline;
import org.eclipse.elk.alg.common.spore.IOverlapHandler;
import org.eclipse.elk.alg.common.spore.Node;
import org.eclipse.elk.alg.common.utils.SVGImage;

public class ScanlineOverlapCheck {
    private IOverlapHandler overlapHandler;
    private SVGImage svg;
    private Comparator<Timestamp> overlapsScanlineComparator = (p1, p2) -> {
        int cmp;
        double y1 = p1.node.rect.y;
        if (!p1.low) {
            y1 += p1.node.rect.height;
        }
        double y2 = p2.node.rect.y;
        if (!p2.low) {
            y2 += p2.node.rect.height;
        }
        if ((cmp = Double.compare(y1, y2)) == 0) {
            if (!p1.low && p2.low) {
                return -1;
            }
            if (!p2.low && p1.low) {
                return 1;
            }
        }
        return cmp;
    };

    public ScanlineOverlapCheck(IOverlapHandler oh, SVGImage dbg) {
        this.svg = dbg;
        this.svg.addGroups("n", "o", "e");
        this.overlapHandler = oh;
    }

    public void sweep(List<Node> nodes) {
        this.svg.clearGroup("n");
        this.svg.clearGroup("o");
        this.svg.clearGroup("e");
        ArrayList points = Lists.newArrayList();
        for (Node n : nodes) {
            points.add(new Timestamp(n, true));
            points.add(new Timestamp(n, false));
            this.svg.g("n").addRect(n.rect, "stroke=\"black\" stroke-width=\"1\" fill=\"none\"");
        }
        this.svg.isave();
        OverlapsScanlineHandler overlapsScanlineHandler = new OverlapsScanlineHandler();
        overlapsScanlineHandler.init();
        Scanline.execute(points, this.overlapsScanlineComparator, overlapsScanlineHandler);
        this.svg.isave();
    }

    private boolean overlap(Node n1, Node n2) {
        if (n1 == null || n2 == null || n1 == n2) {
            return false;
        }
        return DoubleMath.fuzzyCompare((double)n1.rect.x, (double)(n2.rect.x + n2.rect.width), (double)1.0E-4) < 0 && DoubleMath.fuzzyCompare((double)n2.rect.x, (double)(n1.rect.x + n1.rect.width), (double)1.0E-4) < 0;
    }

    private class OverlapsScanlineHandler
    implements Scanline.EventHandler<Timestamp> {
        private TreeSet<Node> intervalsSortLeft = Sets.newTreeSet((n1, n2) -> {
            int cmp = Double.compare(n1.rect.x, n2.rect.x);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(n1.originalVertex.x, n2.originalVertex.x);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(n1.originalVertex.y, n2.originalVertex.y);
        });

        private OverlapsScanlineHandler() {
        }

        public void init() {
            this.intervalsSortLeft.clear();
        }

        @Override
        public void handle(Timestamp p) {
            if (p.low) {
                this.insert(p);
            } else {
                this.delete(p);
            }
        }

        private void insert(Timestamp p) {
            boolean success = this.intervalsSortLeft.add(p.node);
            if (!success) {
                throw new IllegalStateException("Invalid hitboxes for scanline overlap calculation.");
            }
            boolean overlapsFound = false;
            for (Node other : this.intervalsSortLeft) {
                if (ScanlineOverlapCheck.this.overlap(p.node, other)) {
                    ScanlineOverlapCheck.this.overlapHandler.handle(p.node, other);
                    ScanlineOverlapCheck.this.svg.g("o").addRect(p.node.rect, "stroke=\"none\" fill=\"red\" opacity=\"0.18\"");
                    ScanlineOverlapCheck.this.svg.g("o").addRect(other.rect, "stroke=\"none\" fill=\"red\" opacity=\"0.18\"");
                    ScanlineOverlapCheck.this.svg.g("e").addLine(p.node.vertex.x, p.node.vertex.y, other.vertex.x, other.vertex.y, "stroke=\"blue\"");
                    overlapsFound = true;
                    continue;
                }
                if (overlapsFound) break;
            }
        }

        private void delete(Timestamp p) {
            this.intervalsSortLeft.remove(p.node);
        }
    }

    private class Timestamp {
        private boolean low;
        private Node node;

        Timestamp(Node node, boolean low) {
            this.node = node;
            this.low = low;
        }
    }
}

