/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api.widgets;

import java.util.Iterator;
import java.util.List;
import org.eclipse.eef.EEFConditionalStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFFont;
import org.eclipse.eef.util.EEFConditionalStyleToWidgetStyleSwitch;
import org.eclipse.eef.util.EEFDescriptionToConditionalStylesSwitch;
import org.eclipse.eef.util.EEFDescriptionToWidgetStyleSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class EEFStyleHelper {
    private IInterpreter interpreter;
    private IVariableManager variableManager;

    public EEFStyleHelper(IInterpreter interpreter, IVariableManager variableManager) {
        this.interpreter = interpreter;
        this.variableManager = variableManager;
    }

    public EEFWidgetStyle getWidgetStyle(EEFWidgetDescription widgetDescription) {
        EEFWidgetStyle widgetStyle = null;
        List conditionalStyles = (List)this.getDescriptionToConditionalStylesSwitch().doSwitch((EObject)widgetDescription);
        Iterator iterator = conditionalStyles.iterator();
        while (widgetStyle == null && iterator.hasNext()) {
            EEFConditionalStyle conditionalStyle = (EEFConditionalStyle)iterator.next();
            String preconditionExpression = conditionalStyle.getPreconditionExpression();
            Boolean preconditionValid = (Boolean)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(Boolean.class).evaluate(preconditionExpression);
            if (preconditionValid == null || !preconditionValid.booleanValue()) continue;
            widgetStyle = (EEFWidgetStyle)this.getConditionalStyleToWidgetStyleSwitch().doSwitch((EObject)conditionalStyle);
        }
        if (widgetStyle == null) {
            widgetStyle = (EEFWidgetStyle)this.getDescriptionToWidgetStyleSwitch().doSwitch((EObject)widgetDescription);
        }
        return widgetStyle;
    }

    protected Switch<List<EEFConditionalStyle>> getDescriptionToConditionalStylesSwitch() {
        return new EEFDescriptionToConditionalStylesSwitch();
    }

    protected Switch<EEFWidgetStyle> getConditionalStyleToWidgetStyleSwitch() {
        return new EEFConditionalStyleToWidgetStyleSwitch();
    }

    protected Switch<EEFWidgetStyle> getDescriptionToWidgetStyleSwitch() {
        return new EEFDescriptionToWidgetStyleSwitch();
    }

    public void applyTextStyle(String fontNameExpression, String fontSizeExpression, String fontStyleExpression, Font defaultFont, String backgroundColorExpression, String foregroundColorExpression, IEEFTextStyleCallback callback) {
        if (!Util.isBlank((String)foregroundColorExpression)) {
            this.applyForegroundColor(foregroundColorExpression, callback);
        } else {
            callback.applyForegroundColor(new EEFColor(null));
        }
        if (!Util.isBlank((String)backgroundColorExpression)) {
            this.applyBackgroundColor(backgroundColorExpression, callback);
        } else {
            callback.applyBackgroundColor(new EEFColor(null));
        }
        String fontStyleValue = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).evaluate(fontStyleExpression);
        this.applyFont(fontNameExpression, fontSizeExpression, defaultFont, callback, fontStyleValue);
        this.applyFontStyle(callback, fontStyleValue);
    }

    private void applyForegroundColor(String foregroundColorExpression, IEEFTextStyleCallback callback) {
        String foregroundColorCode = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).evaluate(foregroundColorExpression);
        if (!Util.isBlank((String)foregroundColorCode)) {
            callback.applyForegroundColor(new EEFColor(foregroundColorCode));
        }
    }

    private void applyBackgroundColor(String backgroundColorExpression, IEEFTextStyleCallback callback) {
        String backgroundColorCode = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).evaluate(backgroundColorExpression);
        if (!Util.isBlank((String)backgroundColorCode)) {
            callback.applyBackgroundColor(new EEFColor(backgroundColorCode));
        }
    }

    private void applyFont(String fontNameExpression, String fontSizeExpression, Font defaultFont, IEEFTextStyleCallback callback, String fontStyleValue) {
        FontData defaultFontData = defaultFont.getFontData()[0];
        String fontName = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).defaultValue((Object)defaultFontData.getName()).evaluate(fontNameExpression);
        int fontSize = (Integer)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(Integer.class).defaultValue((Object)defaultFontData.getHeight()).evaluate(fontSizeExpression);
        int fontStyle = defaultFontData.getStyle();
        if (fontStyleValue == null) {
            fontStyle = 0;
        } else if (fontStyleValue.contains("bold")) {
            fontStyle |= 1;
        } else if (fontStyleValue.contains("italic")) {
            fontStyle |= 2;
        }
        EEFFont font = new EEFFont(fontName, fontSize, fontStyle);
        callback.applyFont(font);
    }

    private void applyFontStyle(IEEFTextStyleCallback callback, String fontStyleValue) {
        boolean strikeout = false;
        boolean underline = false;
        if (fontStyleValue != null && fontStyleValue.contains("underline")) {
            underline = true;
        }
        if (fontStyleValue != null && fontStyleValue.contains("strike_through")) {
            strikeout = true;
        }
        callback.applyFontStyle(strikeout, underline);
    }

    public static interface IEEFTextStyleCallback {
        public void applyFont(EEFFont var1);

        public void applyFontStyle(boolean var1, boolean var2);

        public void applyForegroundColor(EEFColor var1);

        public void applyBackgroundColor(EEFColor var1);
    }
}

