/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.emf.ecore.EObject;

public class SiriusElkUtil {
    private SiriusElkUtil() {
    }

    public static PrecisionPoint getRoundedCoordinatesAccordingToParents(ElkShape elkShape) {
        PrecisionPoint defaultRoundedCoordinates = new PrecisionPoint(Math.toIntExact(Math.round(elkShape.getX())), Math.toIntExact(Math.round(elkShape.getY())));
        EObject eObject = elkShape.eContainer();
        if (eObject instanceof ElkShape) {
            ElkShape parent = (ElkShape)eObject;
            KVector absoluteELKCoordinates = ElkUtil.absolutePosition((ElkGraphElement)elkShape);
            PrecisionPoint parentRoundedAbsoluteCoordinates = SiriusElkUtil.getRoundedAbsoluteCoordinates(parent);
            PrecisionPoint roundedAbsoluteCoordinates = (PrecisionPoint)defaultRoundedCoordinates.getTranslated((Point)parentRoundedAbsoluteCoordinates);
            Dimension delta = new Dimension((int)(absoluteELKCoordinates.x - roundedAbsoluteCoordinates.preciseX()), (int)(absoluteELKCoordinates.y - roundedAbsoluteCoordinates.preciseY()));
            defaultRoundedCoordinates.translate(delta);
        }
        return defaultRoundedCoordinates;
    }

    private static PrecisionPoint getRoundedAbsoluteCoordinates(ElkShape elkShape) {
        PrecisionPoint roundedCoordinates = SiriusElkUtil.getRoundedCoordinatesAccordingToParents(elkShape);
        EObject eObject = elkShape.eContainer();
        if (eObject instanceof ElkShape) {
            ElkShape parent = (ElkShape)eObject;
            roundedCoordinates.translate((Point)SiriusElkUtil.getRoundedAbsoluteCoordinates(parent));
        }
        return roundedCoordinates;
    }
}

