/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.shellwax.internal.run;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ShMainTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    private Text argumentsText;
    private Text workingDirectoryText;

    public void createControl(Composite parent) {
        Composite resComposite = new Composite(parent, 0);
        resComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(resComposite, 0).setText("Shell script");
        this.programPathText = new Text(resComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            this.setDirty(true);
            File file = new File(this.programPathText.getText());
            if (!file.isFile()) {
                String errorMessage = "Given path doesn't reference a file.";
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else if (!file.canRead()) {
                String errorMessage = "Not allowed to read file.";
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else {
                this.setErrorMessage(null);
                decoration.hide();
            }
            this.updateLaunchConfigurationDialog();
        });
        new Label(resComposite, 0).setText("Arguments");
        this.argumentsText = new Text(resComposite, 2048);
        this.argumentsText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(resComposite, 0).setText("Working directory");
        this.workingDirectoryText = new Text(resComposite, 2048);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.workingDirectoryText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.setControl((Control)resComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.programPathText.setText(configuration.getAttribute("org.eclipse.shellwax.launch.program", ""));
            this.argumentsText.setText(configuration.getAttribute("org.eclipse.shellwax.launch.arguments", ""));
            this.workingDirectoryText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", ""));
        }
        catch (CoreException e) {
            ILog.get().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.shellwax.launch.program", this.programPathText.getText());
        configuration.setAttribute("org.eclipse.shellwax.launch.arguments", this.argumentsText.getText());
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", this.workingDirectoryText.getText());
    }

    public String getName() {
        return "Shell script";
    }
}

