/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.layout.Row;

public class ButtonRow {
    private static final float WIDTH_FACTOR = 0.2f;
    private int maxWidth;
    private final Composite row;

    public ButtonRow(Composite parent) {
        this.row = new Composite(parent, 0);
        Composite space = new Composite(this.row, 0);
        space.setLayout((Layout)new FillLayout());
        this.setLayout();
    }

    public Button add(String text) {
        Button button = new Button(this.row, 0);
        button.setText(text);
        Point size = button.computeSize(-1, -1);
        if (this.maxWidth < size.x) {
            this.maxWidth = size.x;
        }
        this.setLayout();
        return button;
    }

    public Button[] getButtons() {
        return (Button[])this.row.getChildren();
    }

    public Composite getComposite() {
        return this.row;
    }

    private void setLayout() {
        int size = this.row.getChildren().length;
        GridLayout layout = new GridLayout();
        layout.numColumns = size;
        this.row.setLayout((Layout)layout);
    }

    protected Row getInfo(int i) {
        Control control = this.row.getChildren()[i];
        Point size = control.computeSize(-1, -1);
        size.x = Math.round((float)size.x + (float)this.maxWidth * 0.2f);
        return Row.fixed((int)size.x);
    }
}

