/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class DirectedEdgePathExtension {
    public static <E, N, P> boolean contains(DirectedEdgePath<E, N, P> path, DirectedEdge<E, N, P> edge) {
        return IteratorExtensions.toList(path.getEdgeIterator()).contains(edge);
    }

    public static <E, N, P> List<DirectedEdge<E, N, P>> getEdges(DirectedEdgePath<E, N, P> path, N node) {
        LinkedList<DirectedEdge<DirectedEdge<E, N, P>, N, P>> result = new LinkedList<DirectedEdge<DirectedEdge<E, N, P>, N, P>>();
        DirectedEdge<E, N, P> successor = path.getEdgeForTail(node);
        DirectedEdge<E, N, P> predecessor = path.getEdgeForHead(node);
        if (successor != null) {
            result.add(successor);
        }
        if (predecessor != null) {
            result.add(predecessor);
        }
        return result;
    }

    public static <E, N, P> List<N> getNodeList(DirectedEdgePath<E, N, P> path) {
        List<DirectedEdge<E, N, P>> edges = path.getEdgeList();
        boolean _isEmpty = edges.isEmpty();
        if (_isEmpty) {
            return CollectionLiterals.emptyList();
        }
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new Object[]{((DirectedEdge)IterableExtensions.head(edges)).getTail()});
        Consumer<DirectedEdge> _function = it -> result.add(it.getHead());
        edges.forEach(_function);
        return result;
    }
}

