/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.version;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.set.basis.PlanProSchemaDir;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.version.PlanProVersionService;
import org.eclipse.set.model.validationreport.ValidationreportFactory;
import org.eclipse.set.model.validationreport.VersionInfo;
import org.eclipse.set.ppmodel.extensions.PlanProPackageExtensions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component
public class PlanProVersionServiceImpl
implements PlanProVersionService {
    private static final String DELIMITER = "";
    private static final String KEY_VALUE_PATTERN = ".*xmlns:.*=\\s*['\"](%s[^'\" ]+)['\"].*";
    private static final String PLAN_PRO_KEY = "http://www.plan-pro.org/modell/PlanPro/";
    private static final String SIGNALS_KEY = "http://www.plan-pro.org/modell/Signalbegriffe_Ril_301/";
    private static final int VALUE_GROUP = 1;
    private static final String VERSION_FORMAT = "(?<major>[1-9]+\\.[0-9]+)\\.(?<patch>[0-9]+)(\\.(?<minor>[0-9]))*";
    private static final String VERSION_SEPARATOR = ", ";

    @Activate
    private void active() {
        Services.setPlanProVersionService((PlanProVersionService)this);
    }

    private static String getText(Path location) {
        List<String> lines;
        try {
            lines = Files.readAllLines(location);
        }
        catch (IOException e) {
            return DELIMITER;
        }
        List<String> subList = lines.subList(0, Math.min(10, lines.size()));
        return subList.stream().collect(Collectors.joining(DELIMITER));
    }

    private static String parseVersion(String text, String key) {
        Pattern p = Pattern.compile(String.format(KEY_VALUE_PATTERN, key));
        Matcher m = p.matcher(text);
        if (m.matches()) {
            String fullVersion = m.group(1);
            return fullVersion.substring(fullVersion.lastIndexOf(47) + 1);
        }
        return null;
    }

    private static PlanProVersionService.PlanProVersionFormat parseVersionFormat(String version) {
        Pattern compile = Pattern.compile(VERSION_FORMAT);
        Matcher matcher = compile.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal Version Foramt");
        }
        return new PlanProVersionService.PlanProVersionFormat(matcher.group("major"), matcher.group("patch"), matcher.group("minor"));
    }

    public VersionInfo createSupportedVersion() {
        VersionInfo versionInfo = ValidationreportFactory.eINSTANCE.createVersionInfo();
        String modelVersionsSupported = PlanProVersionServiceImpl.getSupportedVersions("PlanPro");
        versionInfo.setPlanPro(modelVersionsSupported);
        String signalbegriffSupportedVersion = PlanProVersionServiceImpl.getSupportedVersions("Signalbegriffe_Ril_301");
        versionInfo.setSignals(signalbegriffSupportedVersion);
        return versionInfo;
    }

    private static String getSupportedVersions(String packageName) {
        return PlanProSchemaDir.getSchemaPaths().stream().filter(p -> p.getFileName().toString().equals(packageName + ".xsd")).map(Path::getParent).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet()).stream().sorted((first, second) -> {
            PlanProVersionService.PlanProVersionFormat firstVersion = PlanProVersionServiceImpl.parseVersionFormat(first);
            PlanProVersionService.PlanProVersionFormat secondVersion = PlanProVersionServiceImpl.parseVersionFormat(second);
            return firstVersion.compare(secondVersion);
        }).collect(Collectors.joining(VERSION_SEPARATOR));
    }

    public VersionInfo createUsedVersion(Path location) {
        VersionInfo versionInfo = ValidationreportFactory.eINSTANCE.createVersionInfo();
        String text = PlanProVersionServiceImpl.getText(location);
        String planProVersion = PlanProVersionServiceImpl.parseVersion(text, PLAN_PRO_KEY);
        versionInfo.setPlanPro(planProVersion != null ? planProVersion : DELIMITER);
        versionInfo.setSignals(PlanProVersionServiceImpl.parseVersion(text, SIGNALS_KEY));
        return versionInfo;
    }

    public PlanProVersionService.PlanProVersionFormat getSupportedVersionFormat() {
        return PlanProVersionServiceImpl.parseVersionFormat(PlanProPackageExtensions.getModelVersion());
    }

    public String getCurrentVersion() {
        return PlanProPackageExtensions.getModelVersion();
    }
}

