/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages.ckeditor.internal;

import org.eclipse.rap.addons.ckeditor.CKEditor;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CKEditorExamplePage
implements IExamplePage {
    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)2));
        this.createEditorExample(parent);
    }

    private void createEditorExample(final Composite parent) {
        Display display = parent.getDisplay();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)true, (boolean)true));
        final CKEditor ckEditor = new CKEditor(composite, 0);
        ckEditor.setText("<b>Rich</b> <i>Text</i> <u>Editor</u>");
        GridData layoutData = new GridData(4, 4, true, true);
        ckEditor.setLayoutData((Object)layoutData);
        ckEditor.setBackground(new Color((Device)display, 247, 247, 247));
        Composite toolbar = new Composite(composite, 0);
        toolbar.setLayoutData((Object)new GridData(4, 4, true, false));
        toolbar.setLayout((Layout)new GridLayout(3, false));
        Button showContent = new Button(toolbar, 8);
        showContent.setText("Show Content");
        showContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CKEditorExamplePage.this.showContent(parent, ckEditor, false);
            }
        });
        Button showSource = new Button(toolbar, 8);
        showSource.setText("Show Source");
        showSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CKEditorExamplePage.this.showContent(parent, ckEditor, true);
            }
        });
        Button clearBtn = new Button(toolbar, 0);
        clearBtn.setText("Clear");
        clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ckEditor.setText("");
            }
        });
    }

    private void showContent(Composite parent, CKEditor ckEditor, boolean source) {
        Text viewer;
        int style = 67680;
        final Shell content = new Shell(parent.getShell(), style);
        content.setLayout((Layout)new GridLayout(1, true));
        String text = ckEditor.getText();
        if (source) {
            content.setText("Rich Text Source");
            viewer = new Text((Composite)content, 66);
            viewer.setLayoutData((Object)new GridData(400, 400));
            viewer.setText(text);
            viewer.setEditable(false);
        } else {
            content.setText("Rich Text");
            viewer = new Browser((Composite)content, 0);
            viewer.setLayoutData((Object)new GridData(400, 400));
            viewer.setText(text);
            viewer.setEnabled(false);
        }
        Button ok = new Button((Composite)content, 8);
        ok.setLayoutData((Object)new GridData(131072, 1024, false, false));
        ok.setText("OK");
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                content.dispose();
            }
        });
        content.setDefaultButton(ok);
        content.pack();
        Display display = parent.getDisplay();
        int left = display.getClientArea().width / 2 - content.getBounds().width / 2;
        content.setLocation(left, 40);
        content.open();
        ok.setFocus();
    }
}

