/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.jface.gridviewer.GridViewerRow;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class GridTreeViewer
extends AbstractTreeViewer {
    private Grid grid;
    private GridViewerRow cachedRow;
    private boolean autoPreferredHeight = false;
    private CellLabelProvider rowHeaderLabelProvider;

    public GridTreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public GridTreeViewer(Composite parent, int style) {
        this(new Grid(parent, style));
    }

    public GridTreeViewer(Grid grid) {
        this.grid = grid;
        this.hookControl((Control)grid);
    }

    public Grid getGrid() {
        return this.grid;
    }

    protected Item getItemAt(Point point) {
        return this.grid.getItem(point);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return new GridViewerEditor((ColumnViewer)this, new ColumnViewerEditorActivationStrategy((ColumnViewer)this), 1);
    }

    protected void addTreeListener(Control control, TreeListener listener) {
        ((Grid)control).addTreeListener(listener);
    }

    protected Item[] getChildren(Widget o) {
        if (o instanceof GridItem) {
            return ((GridItem)o).getItems();
        }
        if (o instanceof Grid) {
            return ((Grid)o).getRootItems();
        }
        return null;
    }

    protected boolean getExpanded(Item item) {
        return ((GridItem)item).isExpanded();
    }

    protected int getItemCount(Control control) {
        return ((Grid)control).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((GridItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((GridItem)item).getItems();
    }

    protected Item getParentItem(Item item) {
        return ((GridItem)item).getParentItem();
    }

    protected Item[] getSelection(Control control) {
        return ((Grid)control).getSelection();
    }

    protected Item newItem(Widget parent, int style, int index) {
        GridItem item = parent instanceof GridItem ? (GridItem)this.createNewRowPart(this.getViewerRowFromItem(parent), style, index).getItem() : (GridItem)this.createNewRowPart(null, style, index).getItem();
        return item;
    }

    private ViewerRow createNewRowPart(ViewerRow parent, int style, int rowIndex) {
        if (parent == null) {
            if (rowIndex >= 0) {
                return this.getViewerRowFromItem((Widget)new GridItem(this.grid, style, rowIndex));
            }
            return this.getViewerRowFromItem((Widget)new GridItem(this.grid, style));
        }
        if (rowIndex >= 0) {
            return this.getViewerRowFromItem((Widget)new GridItem((GridItem)parent.getItem(), 0, rowIndex));
        }
        return this.getViewerRowFromItem((Widget)new GridItem((GridItem)parent.getItem(), 0));
    }

    protected void removeAll(Control control) {
        ((Grid)control).removeAll();
    }

    protected void setExpanded(Item item, boolean expand) {
        ((GridItem)item).setExpanded(expand);
    }

    protected void setSelection(List items) {
        Item[] current = this.getSelection((Control)this.getGrid());
        if (this.isSameSelection(items, current)) {
            return;
        }
        GridItem[] newItems = new GridItem[items.size()];
        items.toArray(newItems);
        this.getGrid().setSelection(newItems);
        this.getGrid().showSelection();
    }

    protected void showItem(Item item) {
        this.getGrid().showItem((GridItem)item);
    }

    public Control getControl() {
        return this.getGrid();
    }

    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new GridViewerRow((GridItem)item);
        } else {
            this.cachedRow.setItem((GridItem)item);
        }
        return this.cachedRow;
    }

    protected Widget getColumnViewerOwner(int columnIndex) {
        if (columnIndex < 0 || columnIndex > 0 && columnIndex >= this.getGrid().getColumnCount()) {
            return null;
        }
        if (this.getGrid().getColumnCount() == 0) {
            return this.getGrid();
        }
        return this.getGrid().getColumn(columnIndex);
    }

    protected int doGetColumnCount() {
        return this.grid.getColumnCount();
    }

    public void setAutoPreferredHeight(boolean autoPreferredHeight) {
        this.autoPreferredHeight = autoPreferredHeight;
    }

    public boolean getAutoPreferredHeight() {
        return this.autoPreferredHeight;
    }

    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        this.updateRowHeader((Widget)item);
        if (this.autoPreferredHeight && !item.isDisposed()) {
            ((GridItem)item).pack();
        }
    }

    public void remove(final Object parentOrTreePath, final int index) {
        if (this.checkBusy()) {
            return;
        }
        final LinkedList<TreePath> oldSelection = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(new Runnable(){

            public void run() {
                TreePath removedPath = null;
                if (GridTreeViewer.this.internalIsInputOrEmptyPath(parentOrTreePath)) {
                    Tree tree = (Tree)GridTreeViewer.this.getControl();
                    if (index < tree.getItemCount()) {
                        TreeItem item = tree.getItem(index);
                        if (item.getData() != null) {
                            removedPath = GridTreeViewer.this.getTreePathFromItem((Item)item);
                            GridTreeViewer.this.disassociate((Item)item);
                        }
                        item.dispose();
                    }
                } else {
                    Widget[] parentItems = GridTreeViewer.this.internalFindItems(parentOrTreePath);
                    int i = 0;
                    while (i < parentItems.length) {
                        TreeItem parentItem = (TreeItem)parentItems[i];
                        if (!parentItem.isDisposed() && index < parentItem.getItemCount()) {
                            TreeItem item = parentItem.getItem(index);
                            if (item.getData() != null) {
                                removedPath = GridTreeViewer.this.getTreePathFromItem((Item)item);
                                GridTreeViewer.this.disassociate((Item)item);
                            }
                            item.dispose();
                        }
                        ++i;
                    }
                }
                if (removedPath != null) {
                    boolean removed = false;
                    Iterator it = oldSelection.iterator();
                    while (it.hasNext()) {
                        TreePath path = (TreePath)it.next();
                        if (!path.startsWith(removedPath, GridTreeViewer.this.getComparer())) continue;
                        it.remove();
                        removed = true;
                    }
                    if (removed) {
                        GridTreeViewer.this.setSelection((ISelection)new TreeSelection(oldSelection.toArray(new TreePath[oldSelection.size()]), GridTreeViewer.this.getComparer()), false);
                    }
                }
            }
        });
    }

    public void setRowHeaderLabelProvider(CellLabelProvider rowHeaderLabelProvider) {
        this.rowHeaderLabelProvider = rowHeaderLabelProvider;
    }

    private void updateRowHeader(Widget widget) {
        if (this.rowHeaderLabelProvider != null) {
            ViewerCell cell = this.getViewerRowFromItem(widget).getCell(Integer.MAX_VALUE);
            this.rowHeaderLabelProvider.update(cell);
        }
    }
}

