/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;

public class RulerRootEditPart
extends SimpleRootEditPart {
    private static final Insets VERTICAL_THRESHOLD = new Insets(18, 0, 18, 0);
    private static final Insets HORIZONTAL_THRESHOLD = new Insets(0, 18, 0, 18);
    private boolean horizontal;

    public RulerRootEditPart(boolean isHorzontal) {
        this.horizontal = isHorzontal;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getViewport().setContents(child);
    }

    protected IFigure createFigure() {
        return new RulerViewport();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AutoexposeHelper.class) {
            if (((RulerEditPart)this.getContents()).isHorizontal()) {
                return new ViewportAutoexposeHelper(this, HORIZONTAL_THRESHOLD);
            }
            return new ViewportAutoexposeHelper(this, VERTICAL_THRESHOLD);
        }
        return super.getAdapter(adapter);
    }

    protected Viewport getViewport() {
        return (Viewport)this.getFigure();
    }

    protected void removeChildVisual(EditPart childEditPart) {
        this.getViewport().setContents(null);
    }

    public class RulerViewport
    extends Viewport {
        public RulerViewport() {
            super(true);
            this.setLayoutManager(null);
            RangeModel bogusRangeModel = RulerRootEditPart.this.horizontal ? this.getVerticalRangeModel() : this.getHorizontalRangeModel();
            bogusRangeModel.setMinimum(0);
            bogusRangeModel.setMaximum(100);
            bogusRangeModel.setValue(0);
            bogusRangeModel.setExtent(100);
        }

        protected void doLayout(boolean force) {
            this.repaint();
            if (force) {
                RangeModel rModel = RulerRootEditPart.this.horizontal ? this.getHorizontalRangeModel() : this.getVerticalRangeModel();
                Rectangle contentBounds = Rectangle.getSINGLETON();
                if (RulerRootEditPart.this.horizontal) {
                    contentBounds.y = 0;
                    contentBounds.x = rModel.getMinimum();
                    contentBounds.height = this.getContents().getPreferredSize().height;
                    contentBounds.width = rModel.getMaximum() - rModel.getMinimum();
                } else {
                    contentBounds.y = rModel.getMinimum();
                    contentBounds.x = 0;
                    contentBounds.height = rModel.getMaximum() - rModel.getMinimum();
                    contentBounds.width = this.getContents().getPreferredSize().width;
                }
                if (!this.getContents().getBounds().equals((Object)contentBounds)) {
                    this.getContents().setBounds(contentBounds);
                    this.getContents().revalidate();
                }
            }
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            if (this.getContents() == null) {
                return new Dimension();
            }
            Dimension pSize = this.getContents().getPreferredSize(wHint, hHint);
            if (RulerRootEditPart.this.horizontal) {
                RangeModel rModel = this.getHorizontalRangeModel();
                pSize.width = rModel.getMaximum() - rModel.getMinimum();
            } else {
                RangeModel rModel = this.getVerticalRangeModel();
                pSize.height = rModel.getMaximum() - rModel.getMinimum();
            }
            return pSize.expand(this.getInsets().getWidth(), this.getInsets().getHeight());
        }

        protected void readjustScrollBars() {
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.getContents() != null && ((RulerFigure)this.getContents()).getDrawFocus()) {
                Rectangle focusBounds = this.getBounds().getCopy();
                if (((RulerFigure)this.getContents()).isHorizontal()) {
                    focusBounds.resize(-2, -4);
                    ++focusBounds.x;
                } else {
                    focusBounds.resize(-4, -2);
                    ++focusBounds.y;
                }
                graphics.setForegroundColor(ColorConstants.black());
                graphics.setBackgroundColor(ColorConstants.white());
                graphics.drawFocus(focusBounds);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.getContents() != null && event.getSource() instanceof RangeModel) {
                String property = event.getPropertyName();
                this.doLayout("maximum".equals(property) || "minimum".equals(property) || "value".equals(property));
            }
        }

        public void setContents(IFigure figure) {
            super.setContents(figure);
            if (this.getContents() != null) {
                this.doLayout(true);
            }
        }

        protected boolean useLocalCoordinates() {
            return true;
        }
    }
}

