/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.ckeditor;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CKEditor
extends Composite {
    private static final String RESOURCES_PATH = "resources/";
    private static final String REGISTER_PATH = "ckeditor/";
    private static final String[] RESOURCE_FILES = new String[]{"ckeditor.js", "config.js", "handler.js", "contents.css", "lang/en.js", "skins/kama/editor.css", "skins/kama/icons.png", "skins/kama/images/sprites.png", "skins/kama/images/sprites_ie6.png"};
    private static final String REMOTE_TYPE = "eclipsesource.CKEditor";
    private String text = "";
    private final RemoteObject remoteObject;
    private final OperationHandler operationHandler = new AbstractOperationHandler(){

        public void handleSet(JsonObject properties) {
            JsonValue textValue = properties.get("text");
            if (textValue != null) {
                CKEditor.this.text = textValue.asString();
            }
        }
    };

    public CKEditor(Composite parent, int style) {
        super(parent, style);
        CKEditor.registerResources();
        CKEditor.loadJavaScript();
        Connection connection = RWT.getUISession().getConnection();
        this.remoteObject = connection.createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler(this.operationHandler);
        this.remoteObject.set("parent", WidgetUtil.getId((Widget)this));
    }

    private static void registerResources() {
        ResourceManager resourceManager = RWT.getResourceManager();
        boolean isRegistered = resourceManager.isRegistered(REGISTER_PATH + RESOURCE_FILES[0]);
        if (!isRegistered) {
            try {
                String[] stringArray = RESOURCE_FILES;
                int n = RESOURCE_FILES.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    CKEditor.register(resourceManager, fileName);
                    ++n2;
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to load resources", ioe);
            }
        }
    }

    private static void loadJavaScript() {
        JavaScriptLoader jsLoader = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
        ResourceManager resourceManager = RWT.getResourceManager();
        jsLoader.require(resourceManager.getLocation("ckeditor/handler.js"));
        jsLoader.require(resourceManager.getLocation("ckeditor/ckeditor.js"));
        jsLoader.require(resourceManager.getLocation("ckeditor/config.js"));
    }

    private static void register(ResourceManager resourceManager, String fileName) throws IOException {
        ClassLoader classLoader = CKEditor.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(RESOURCES_PATH + fileName);){
            resourceManager.register(REGISTER_PATH + fileName, inputStream);
        }
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Cannot change internal layout of CkEditor");
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.remoteObject.set("font", this.getCssFont());
    }

    public void dispose() {
        this.remoteObject.destroy();
        super.dispose();
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        this.text = text;
        this.remoteObject.set("text", text);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    private String getCssFont() {
        StringBuilder result = new StringBuilder();
        if (this.getFont() != null) {
            FontData data = this.getFont().getFontData()[0];
            result.append(data.getHeight());
            result.append("px ");
            result.append(data.getName());
        }
        return result.toString();
    }
}

