/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.handles;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class MoveHandle
extends AbstractHandle {
    protected static final int INNER_PAD = 2;

    public MoveHandle(GraphicalEditPart owner) {
        this(owner, new MoveHandleLocator(owner.getFigure()));
    }

    public MoveHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
        this.initialize();
    }

    protected DragTracker createDragTracker() {
        DragEditPartsTracker tracker = new DragEditPartsTracker(this.getOwner());
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        return !Rectangle.getSINGLETON().setBounds(this.getBounds()).shrink(2, 2).contains(x, y);
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getTopRight().translate(-1, this.getBounds().height / 4);
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setBorder((Border)new LineBorder(1));
        this.setCursor(Cursors.SIZEALL);
    }
}

