/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.io.IOException;
import java.util.List;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectRegistry;
import org.eclipse.rap.rwt.lifecycle.WidgetLifeCycleAdapter;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractWidgetLCA
implements WidgetLifeCycleAdapter {
    public void render(Widget widget) throws IOException {
        WidgetAdapterImpl adapter = (WidgetAdapterImpl)WidgetUtil.getAdapter(widget);
        if (!adapter.isInitialized()) {
            this.renderInitialization(widget);
        }
        this.renderChanges(widget);
        adapter.setInitialized(true);
    }

    public void readData(Widget widget) {
        String id;
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        List<Operation> operations = clientMessage.getAllOperationsFor(id = WidgetUtil.getId(widget));
        if (!operations.isEmpty()) {
            OperationHandler handler = AbstractWidgetLCA.getOperationHandler(id);
            for (Operation operation : operations) {
                ProtocolUtil.handleOperation(handler, operation);
            }
        }
    }

    public abstract void preserveValues(Widget var1);

    public abstract void renderInitialization(Widget var1) throws IOException;

    public abstract void renderChanges(Widget var1) throws IOException;

    public void renderDispose(Widget widget) throws IOException {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(widget);
        if (adapter.getParent() == null || !adapter.getParent().isDisposed()) {
            remoteObject.destroy();
        } else {
            ((RemoteObjectImpl)remoteObject).markDestroyed();
        }
    }

    public void doRedrawFake(Control control) {
    }

    private static OperationHandler getOperationHandler(String id) {
        RemoteObjectImpl remoteObject = RemoteObjectRegistry.getInstance().get(id);
        if (remoteObject == null) {
            throw new IllegalStateException("No remote object found for widget: " + id);
        }
        OperationHandler handler = remoteObject.getHandler();
        if (handler == null) {
            throw new IllegalStateException("No operation handler found for widget: " + id);
        }
        return handler;
    }
}

