/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt.rap;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RAPSashRenderer
extends SWTPartRenderer {
    private Set<MElementContainer<MUIElement>> contentProcessing = new HashSet<MElementContainer<MUIElement>>();
    private boolean layoutUpdateInProgress = false;
    @Inject
    private IEventBroker broker;
    private EventHandler orientationHandler;
    private EventHandler containerDataHandler;
    private Listener resizeListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            if (RAPSashRenderer.this.contentProcessing.isEmpty()) {
                return;
            }
            try {
                RAPSashRenderer.this.layoutUpdateInProgress = true;
                MUIElement e = (MUIElement)event.widget.getData("modelElement");
                if (e instanceof MPartSashContainerElement && ((EObject)e).eContainer() instanceof MPartSashContainer && ((MPartSashContainer)((EObject)e).eContainer()).getRenderer() == RAPSashRenderer.this) {
                    RAPSashRenderer.this.updateWeight((MPartSashContainerElement)e);
                }
            }
            finally {
                RAPSashRenderer.this.layoutUpdateInProgress = false;
            }
        }
    };

    private void updateWeight(MPartSashContainerElement e) {
        SashForm s = (SashForm)e.getParent().getWidget();
        Widget child = (Widget)e.getWidget();
        int[] weights = s.getWeights();
        Control[] children = s.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == child) {
                e.setContainerData(Integer.toString(weights[i]));
            }
            ++i;
        }
    }

    @PostConstruct
    void postConstruct() {
        this.orientationHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (element.getRenderer() == RAPSashRenderer.this) {
                    MPartSashContainer c = (MPartSashContainer)element;
                    ((SashForm)element.getWidget()).setOrientation(c.isHorizontal() ? 256 : 512);
                }
            }
        };
        this.containerDataHandler = new EventHandler(){

            public void handleEvent(Event arg0) {
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/GenericTile/horizontal/*", this.orientationHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/containerData/*", this.containerDataHandler);
    }

    @PreDestroy
    void preDestroy() {
    }

    public Object createWidget(MUIElement element, Object parent) {
        MPartSashContainer sashElement = (MPartSashContainer)element;
        SashForm sashForm = new SashForm((Composite)parent, sashElement.isHorizontal() ? 256 : 512);
        return sashForm;
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        try {
            this.contentProcessing.add(container);
            super.processContents(container);
        }
        finally {
            this.contentProcessing.remove(container);
        }
        int vIdx = 0;
        int[] weights = new int[container.getChildren().size()];
        for (MUIElement c : container.getChildren()) {
            if (!c.isToBeRendered()) continue;
            weights[vIdx++] = RAPSashRenderer.getWeight(c);
        }
        if (weights.length != vIdx) {
            int[] newWeights = new int[vIdx];
            System.arraycopy(weights, 0, newWeights, 0, vIdx);
            weights = newWeights;
        }
        ((SashForm)container.getWidget()).setWeights(weights);
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        Widget widget = (Widget)element.getWidget();
        widget.addListener(11, this.resizeListener);
        if (!this.contentProcessing.contains(parentElement)) {
            SashForm w = (SashForm)parentElement.getWidget();
            int[] weights = w.getWeights();
            int idx = this.calcVisibleIndex(element);
            weights[idx] = RAPSashRenderer.getWeight(element);
            w.setWeights(weights);
        }
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
    }

    private static int getWeight(MUIElement element) {
        String info = element.getContainerData();
        if (info == null || info.length() == 0) {
            element.setContainerData(Integer.toString(10000));
            info = element.getContainerData();
        }
        try {
            int value = Integer.parseInt(info);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    static /* synthetic */ boolean access$3(RAPSashRenderer rAPSashRenderer) {
        return rAPSashRenderer.layoutUpdateInProgress;
    }
}

