/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.addons.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.addons.camera.Camera;
import org.eclipse.rap.rwt.addons.scanner.ScanListener;
import org.eclipse.rap.rwt.client.service.ClientFileLoader;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.widgets.compositekit.CompositeOperationHandler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class BarcodeScanner
extends Composite {
    private static final String TYPE_BARCODE_SCANNER = "rwt.widgets.BarcodeScanner";
    private static final String PROPERTY_PARENT = "parent";
    private static final String PROPERTY_FORMATS = "formats";
    private static final String PROPERTY_FORMAT = "format";
    private static final String PROPERTY_RUNNING = "running";
    private static final String PROPERTY_DATA = "data";
    private static final String PROPERTY_RAW_DATA = "rawData";
    private static final String PROPERTY_ERROR_MESSAGE = "errorMessage";
    private static final String METHOD_START = "start";
    private static final String METHOD_STOP = "stop";
    private static final String EVENT_SUCCESS = "Success";
    private static final String EVENT_ERROR = "Error";
    private static final String RESOURCES_PATH = "org/eclipse/rap/rwt/addons/scanner/";
    private static final String REGISTER_PATH = "scanner/";
    private static final String[] RESOURCES_FILES = new String[]{"BarcodeScanner.js", "camera-flip-32.png"};
    private static final String PROP_ZXING_JS_URL = "org.eclipse.rap.rwt.addons.scanner.zxingJsUrl";
    private static final String DEF_ZXING_JS_URL = "https://unpkg.com/@zxing/browser@0.1.5";
    private final RemoteObject remoteObject;
    private final List<ScanListener> scanListeners = new ArrayList<ScanListener>();
    private boolean running;

    public BarcodeScanner(Composite parent) {
        this(parent, 0);
    }

    public BarcodeScanner(Composite parent, int style) {
        super(parent, style);
        BarcodeScanner.registerResources();
        BarcodeScanner.loadJavaScript();
        Connection connection = RWT.getUISession().getConnection();
        this.remoteObject = connection.createRemoteObject(TYPE_BARCODE_SCANNER);
        this.remoteObject.setHandler((OperationHandler)new BarcodeScannerOperationHandler(this));
        this.remoteObject.set(PROPERTY_PARENT, WidgetUtil.getId((Widget)this));
    }

    public void start(Formats[] formats) {
        this.checkWidget();
        if (!this.running) {
            JsonObject props = new JsonObject();
            JsonArray jsonFormats = new JsonArray();
            Formats[] formatsArray = formats;
            int n = formats.length;
            int n2 = 0;
            while (n2 < n) {
                Formats format = formatsArray[n2];
                jsonFormats.add(format.toString());
                ++n2;
            }
            props.add(PROPERTY_FORMATS, (JsonValue)jsonFormats);
            this.remoteObject.call(METHOD_START, props);
            this.running = true;
        }
    }

    public void stop() {
        this.checkWidget();
        if (this.running) {
            this.remoteObject.call(METHOD_STOP, null);
            this.running = false;
        }
    }

    public boolean isRunning() {
        this.checkWidget();
        return this.running;
    }

    public void addScanListener(ScanListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.scanListeners.add(listener);
    }

    public void removeScanListener(ScanListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.scanListeners.remove(listener);
    }

    private static void registerResources() {
        ResourceManager resourceManager = RWT.getResourceManager();
        String[] stringArray = RESOURCES_FILES;
        int n = RESOURCES_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            BarcodeScanner.registerFileIfNeeded(resourceManager, fileName);
            ++n2;
        }
    }

    private static void registerFileIfNeeded(ResourceManager resourceManager, String fileName) {
        boolean isRegistered = resourceManager.isRegistered(REGISTER_PATH + fileName);
        if (!isRegistered) {
            try {
                BarcodeScanner.register(resourceManager, fileName);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to load resources", ioe);
            }
        }
    }

    private static void loadJavaScript() {
        ClientFileLoader loader = (ClientFileLoader)RWT.getClient().getService(ClientFileLoader.class);
        ResourceManager resourceManager = RWT.getResourceManager();
        loader.requireJs(System.getProperty(PROP_ZXING_JS_URL, DEF_ZXING_JS_URL));
        loader.requireJs(resourceManager.getLocation("scanner/BarcodeScanner.js"));
    }

    private static void register(ResourceManager resourceManager, String fileName) throws IOException {
        ClassLoader classLoader = Camera.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(RESOURCES_PATH + fileName);){
            resourceManager.register(REGISTER_PATH + fileName, inputStream);
        }
    }

    private class BarcodeScannerOperationHandler
    extends CompositeOperationHandler {
        public BarcodeScannerOperationHandler(BarcodeScanner scanner) {
            super((Composite)scanner);
        }

        public void handleSet(Composite control, JsonObject properties) {
            super.handleSet((Control)control, properties);
            this.handleSetRunning(control, properties);
        }

        public void handleSetRunning(Composite control, JsonObject properties) {
            JsonValue value = properties.get(BarcodeScanner.PROPERTY_RUNNING);
            if (value != null) {
                BarcodeScanner.this.running = value.asBoolean();
            }
        }

        public void handleNotify(Composite control, String eventName, JsonObject properties) {
            if (BarcodeScanner.EVENT_SUCCESS.equals(eventName)) {
                this.notifyScanSucceeded((BarcodeScanner)control, properties);
            } else if (BarcodeScanner.EVENT_ERROR.equals(eventName)) {
                this.notifyScanFailed((BarcodeScanner)control, properties);
            } else {
                super.handleNotify((Control)control, eventName, properties);
            }
        }

        private void notifyScanSucceeded(BarcodeScanner scanner, final JsonObject properties) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScanListener[] listeners;
                    ScanListener[] scanListenerArray = listeners = ((BarcodeScannerOperationHandler)BarcodeScannerOperationHandler.this).BarcodeScanner.this.scanListeners.toArray(new ScanListener[0]);
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScanListener listener = scanListenerArray[n2];
                        String format = properties.get(BarcodeScanner.PROPERTY_FORMAT).asString();
                        String data = properties.get(BarcodeScanner.PROPERTY_DATA).asString();
                        int[] rawData = BarcodeScannerOperationHandler.toIntArray(properties.get(BarcodeScanner.PROPERTY_RAW_DATA).asArray());
                        listener.scanSucceeded(format, data, rawData);
                        ++n2;
                    }
                }
            });
        }

        private void notifyScanFailed(BarcodeScanner scanner, final JsonObject properties) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScanListener[] listeners;
                    ScanListener[] scanListenerArray = listeners = ((BarcodeScannerOperationHandler)BarcodeScannerOperationHandler.this).BarcodeScanner.this.scanListeners.toArray(new ScanListener[0]);
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScanListener listener = scanListenerArray[n2];
                        String error = properties.get(BarcodeScanner.PROPERTY_ERROR_MESSAGE).asString();
                        listener.scanFailed(error);
                        ++n2;
                    }
                }
            });
        }

        private static int[] toIntArray(JsonArray array) {
            int[] intArray = new int[array.size()];
            int i = 0;
            while (i < array.size()) {
                intArray[i] = array.get(i).asInt();
                ++i;
            }
            return intArray;
        }
    }

    public static enum Formats {
        UPC_A,
        UPC_E,
        CODE_39,
        CODE_93,
        CODE_128,
        EAN_8,
        EAN_13,
        PDF_417,
        QR_CODE,
        AZTEC,
        ITF,
        DATA_MATRIX,
        CODABAR;

    }
}

