/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public abstract class DatabaseObjectDefinition
implements Cloneable,
Serializable {
    @Deprecated(forRemoval=true, since="4.0.9")
    public String name;
    @Deprecated(forRemoval=true, since="4.0.9")
    public String qualifier;

    @Deprecated(forRemoval=true, since="4.0.9")
    protected static final FieldTypeDefinition getFieldTypeDefinition(AbstractSession session, Class<?> type, String name) {
        FieldTypeDefinition fieldType;
        FieldTypeDefinition fieldTypeDefinition = fieldType = type != null ? session.getPlatform().getFieldTypeDefinition(type) : new FieldTypeDefinition(name);
        if (fieldType == null) {
            throw ValidationException.javaTypeIsNotAValidDatabaseType(type);
        }
        return fieldType;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    protected static final FieldTypeDefinition getFieldTypeDefinition(DatabasePlatform platform, Class<?> type, String name) {
        FieldTypeDefinition fieldType;
        if (type != null) {
            fieldType = platform.getFieldTypeDefinition(type);
            if (fieldType == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(type);
            }
        } else if (name != null) {
            Map<String, Class<?>> fieldTypes = platform.getClassTypes();
            Class<?> typeFromName = fieldTypes.get(name);
            if (typeFromName == null) {
                fieldType = new FieldTypeDefinition(name);
            } else {
                fieldType = platform.getFieldTypeDefinition(typeFromName);
                if (fieldType == null) {
                    throw ValidationException.javaTypeIsNotAValidDatabaseType(typeFromName);
                }
            }
        } else {
            throw ValidationException.javaTypeIsNotAValidDatabaseType(null);
        }
        return fieldType;
    }

    protected DatabaseObjectDefinition() {
        this("", "");
    }

    protected DatabaseObjectDefinition(String name) {
        this(name, "");
    }

    protected DatabaseObjectDefinition(String name, String qualifier) {
        this.name = name;
        this.qualifier = qualifier;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public abstract Writer buildCreationWriter(AbstractSession var1, Writer var2) throws ValidationException;

    @Deprecated(forRemoval=true, since="4.0.9")
    public Writer buildVPDCreationPolicyWriter(AbstractSession session, Writer writer) {
        return null;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public Writer buildVPDCreationFunctionWriter(AbstractSession session, Writer writer) {
        return null;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public Writer buildVPDDeletionWriter(AbstractSession session, Writer writer) {
        return null;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public abstract Writer buildDeletionWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void createDatabaseSchema(AbstractSession session, Writer writer, Set<String> createdDatabaseSchemas) throws EclipseLinkException {
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void createDatabaseSchemaOnDatabase(AbstractSession session, Set<String> createdDatabaseSchemas) throws EclipseLinkException {
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void createObject(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.createOnDatabase(session);
        } else {
            this.buildCreationWriter(session, schemaWriter);
            if (this.shouldCreateVPDCalls(session)) {
                this.buildVPDCreationPolicyWriter(session, schemaWriter);
                this.buildVPDCreationFunctionWriter(session, schemaWriter);
            }
        }
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void createOnDatabase(AbstractSession session) throws EclipseLinkException {
        session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildCreationWriter(session, new StringWriter()).toString()));
        if (this.shouldCreateVPDCalls(session)) {
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildVPDCreationPolicyWriter(session, new StringWriter()).toString()));
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildVPDCreationFunctionWriter(session, new StringWriter()).toString()));
        }
    }

    public boolean shouldCreateDatabaseSchema(Set<String> createdDatabaseSchemas) {
        return false;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public boolean shouldCreateVPDCalls(AbstractSession session) {
        return false;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void dropDatabaseSchema(AbstractSession session, Writer writer) throws EclipseLinkException {
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void dropDatabaseSchemaOnDatabase(AbstractSession session) throws EclipseLinkException {
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void dropFromDatabase(AbstractSession session) throws EclipseLinkException {
        session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildDeletionWriter(session, new StringWriter()).toString()));
        if (this.shouldCreateVPDCalls(session)) {
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildVPDDeletionWriter(session, new StringWriter()).toString()));
        }
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void dropObject(AbstractSession session, Writer schemaWriter, boolean createSQLFiles) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropFromDatabase(session);
        } else {
            this.buildDeletionWriter(session, schemaWriter);
            if (this.shouldCreateVPDCalls(session)) {
                this.buildVPDDeletionWriter(session, schemaWriter);
            }
        }
    }

    public String getDatabaseSchema() {
        return null;
    }

    public String getFullName() {
        if (this.getQualifier().isEmpty()) {
            return this.getName();
        }
        return this.getQualifier() + "." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    protected boolean hasDatabaseSchema() {
        return this.getDatabaseSchema() != null && !this.getDatabaseSchema().isEmpty();
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void postCreateObject(AbstractSession session, Writer createSchemaWriter, boolean createSQLFiles) {
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void preDropObject(AbstractSession session, Writer dropSchemaWriter, boolean createSQLFiles) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFullName() + ")";
    }
}

